/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.message;

import io.zeebe.engine.processing.message.MessageCorrelator;
import io.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.zeebe.engine.processing.streamprocessor.sideeffect.SideEffectProducer;
import io.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.zeebe.engine.state.KeyGenerator;
import io.zeebe.engine.state.immutable.MessageState;
import io.zeebe.engine.state.immutable.MessageSubscriptionState;
import io.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.zeebe.util.buffer.BufferUtil;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;

public final class MessageSubscriptionCreateProcessor
implements TypedRecordProcessor<MessageSubscriptionRecord> {
    private static final String SUBSCRIPTION_ALREADY_OPENED_MESSAGE = "Expected to open a new message subscription for element with key '%d' and message name '%s', but there is already a message subscription for that element key and message name opened";
    private final MessageCorrelator messageCorrelator;
    private final MessageSubscriptionState subscriptionState;
    private final SubscriptionCommandSender commandSender;
    private final StateWriter stateWriter;
    private final KeyGenerator keyGenerator;
    private MessageSubscriptionRecord subscriptionRecord;

    public MessageSubscriptionCreateProcessor(MessageState messageState, MessageSubscriptionState subscriptionState, SubscriptionCommandSender commandSender, Writers writers, KeyGenerator keyGenerator) {
        this.subscriptionState = subscriptionState;
        this.commandSender = commandSender;
        this.stateWriter = writers.state();
        this.keyGenerator = keyGenerator;
        this.messageCorrelator = new MessageCorrelator(messageState, commandSender, this.stateWriter);
    }

    @Override
    public void processRecord(TypedRecord<MessageSubscriptionRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect) {
        this.subscriptionRecord = record.getValue();
        if (this.subscriptionState.existSubscriptionForElementInstance(this.subscriptionRecord.getElementInstanceKey(), this.subscriptionRecord.getMessageNameBuffer())) {
            sideEffect.accept(this::sendAcknowledgeCommand);
            streamWriter.appendRejection(record, RejectionType.INVALID_STATE, String.format(SUBSCRIPTION_ALREADY_OPENED_MESSAGE, this.subscriptionRecord.getElementInstanceKey(), BufferUtil.bufferAsString((DirectBuffer)this.subscriptionRecord.getMessageNameBuffer())));
            return;
        }
        this.handleNewSubscription(sideEffect);
    }

    private void handleNewSubscription(Consumer<SideEffectProducer> sideEffect) {
        long subscriptionKey = this.keyGenerator.nextKey();
        this.stateWriter.appendFollowUpEvent(subscriptionKey, (Intent)MessageSubscriptionIntent.CREATED, (RecordValue)this.subscriptionRecord);
        boolean isMessageCorrelated = this.messageCorrelator.correlateNextMessage(subscriptionKey, this.subscriptionRecord, sideEffect);
        if (!isMessageCorrelated) {
            sideEffect.accept(this::sendAcknowledgeCommand);
        }
    }

    private boolean sendAcknowledgeCommand() {
        return this.commandSender.openProcessInstanceSubscription(this.subscriptionRecord.getProcessInstanceKey(), this.subscriptionRecord.getElementInstanceKey(), this.subscriptionRecord.getMessageNameBuffer(), this.subscriptionRecord.isInterrupting());
    }
}

