/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.message;

import io.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.zeebe.engine.state.message.MessageSubscription;
import io.zeebe.engine.state.mutable.MutableMessageSubscriptionState;
import io.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.zeebe.util.sched.clock.ActorClock;

public final class PendingMessageSubscriptionChecker
implements Runnable {
    private final SubscriptionCommandSender commandSender;
    private final MutableMessageSubscriptionState subscriptionState;
    private final long subscriptionTimeout;

    public PendingMessageSubscriptionChecker(SubscriptionCommandSender commandSender, MutableMessageSubscriptionState subscriptionState, long subscriptionTimeout) {
        this.commandSender = commandSender;
        this.subscriptionState = subscriptionState;
        this.subscriptionTimeout = subscriptionTimeout;
    }

    @Override
    public void run() {
        this.subscriptionState.visitSubscriptionBefore(ActorClock.currentTimeMillis() - this.subscriptionTimeout, this::sendCommand);
    }

    private boolean sendCommand(MessageSubscription subscription) {
        MessageSubscriptionRecord record = subscription.getRecord();
        boolean success = this.commandSender.correlateProcessInstanceSubscription(record.getProcessInstanceKey(), record.getElementInstanceKey(), record.getBpmnProcessIdBuffer(), record.getMessageNameBuffer(), record.getMessageKey(), record.getVariablesBuffer(), record.getCorrelationKeyBuffer());
        if (success) {
            long sentTime = ActorClock.currentTimeMillis();
            this.subscriptionState.updateSentTimeInTransaction(subscription, sentTime);
        }
        return success;
    }
}

