/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.message;

import io.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.zeebe.engine.state.message.ProcessInstanceSubscription;
import io.zeebe.engine.state.mutable.MutableProcessInstanceSubscriptionState;
import io.zeebe.util.sched.clock.ActorClock;

public final class PendingProcessInstanceSubscriptionChecker
implements Runnable {
    private final SubscriptionCommandSender commandSender;
    private final MutableProcessInstanceSubscriptionState subscriptionState;
    private final long subscriptionTimeout;

    public PendingProcessInstanceSubscriptionChecker(SubscriptionCommandSender commandSender, MutableProcessInstanceSubscriptionState subscriptionState, long subscriptionTimeout) {
        this.commandSender = commandSender;
        this.subscriptionState = subscriptionState;
        this.subscriptionTimeout = subscriptionTimeout;
    }

    @Override
    public void run() {
        this.subscriptionState.visitSubscriptionBefore(ActorClock.currentTimeMillis() - this.subscriptionTimeout, this::sendCommand);
    }

    private boolean sendCommand(ProcessInstanceSubscription subscription) {
        boolean success = subscription.isOpening() ? this.sendOpenCommand(subscription) : this.sendCloseCommand(subscription);
        if (success) {
            this.subscriptionState.updateSentTimeInTransaction(subscription, ActorClock.currentTimeMillis());
        }
        return success;
    }

    private boolean sendOpenCommand(ProcessInstanceSubscription subscription) {
        return this.commandSender.openMessageSubscription(subscription.getSubscriptionPartitionId(), subscription.getProcessInstanceKey(), subscription.getElementInstanceKey(), subscription.getBpmnProcessId(), subscription.getMessageName(), subscription.getCorrelationKey(), subscription.shouldCloseOnCorrelate());
    }

    private boolean sendCloseCommand(ProcessInstanceSubscription subscription) {
        return this.commandSender.closeMessageSubscription(subscription.getSubscriptionPartitionId(), subscription.getProcessInstanceKey(), subscription.getElementInstanceKey(), subscription.getMessageName());
    }
}

