/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.message;

import io.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.zeebe.engine.state.immutable.ProcessInstanceSubscriptionState;
import io.zeebe.engine.state.message.ProcessInstanceSubscription;
import io.zeebe.protocol.impl.record.value.message.ProcessInstanceSubscriptionRecord;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.ProcessInstanceSubscriptionIntent;
import io.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class ProcessInstanceSubscriptionCreateProcessor
implements TypedRecordProcessor<ProcessInstanceSubscriptionRecord> {
    private static final String NO_SUBSCRIPTION_FOUND_MESSAGE = "Expected to create process instance subscription with element key '%d' and message name '%s', but no such subscription was found";
    private static final String NOT_OPENING_MSG = "Expected to create process instance subscription with element key '%d' and message name '%s', but it is already %s";
    private final ProcessInstanceSubscriptionState subscriptionState;
    private final StateWriter stateWriter;
    private final TypedRejectionWriter rejectionWriter;

    public ProcessInstanceSubscriptionCreateProcessor(ProcessInstanceSubscriptionState subscriptionState, Writers writers) {
        this.subscriptionState = subscriptionState;
        this.stateWriter = writers.state();
        this.rejectionWriter = writers.rejection();
    }

    @Override
    public void processRecord(TypedRecord<ProcessInstanceSubscriptionRecord> command, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter) {
        ProcessInstanceSubscriptionRecord subscriptionRecord = command.getValue();
        ProcessInstanceSubscription subscription = this.subscriptionState.getSubscription(subscriptionRecord.getElementInstanceKey(), subscriptionRecord.getMessageNameBuffer());
        if (subscription != null && subscription.isOpening()) {
            this.stateWriter.appendFollowUpEvent(command.getKey(), (Intent)ProcessInstanceSubscriptionIntent.CREATED, (RecordValue)subscriptionRecord);
        } else {
            this.rejectCommand(command, subscription);
        }
    }

    private void rejectCommand(TypedRecord<ProcessInstanceSubscriptionRecord> command, ProcessInstanceSubscription subscription) {
        ProcessInstanceSubscriptionRecord record = command.getValue();
        long elementInstanceKey = record.getElementInstanceKey();
        String messageName = BufferUtil.bufferAsString((DirectBuffer)record.getMessageNameBuffer());
        if (subscription == null) {
            String reason = String.format(NO_SUBSCRIPTION_FOUND_MESSAGE, elementInstanceKey, messageName);
            this.rejectionWriter.appendRejection(command, RejectionType.NOT_FOUND, reason);
        } else {
            String state = subscription.isClosing() ? "closing" : "opened";
            String reason = String.format(NOT_OPENING_MSG, elementInstanceKey, messageName, state);
            this.rejectionWriter.appendRejection(command, RejectionType.INVALID_STATE, reason);
        }
    }
}

