/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.message;

import io.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.zeebe.engine.state.immutable.ProcessInstanceSubscriptionState;
import io.zeebe.protocol.impl.record.value.message.ProcessInstanceSubscriptionRecord;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.ProcessInstanceSubscriptionIntent;
import io.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class ProcessInstanceSubscriptionDeleteProcessor
implements TypedRecordProcessor<ProcessInstanceSubscriptionRecord> {
    private static final String NO_SUBSCRIPTION_FOUND_MESSAGE = "Expected to delete process instance subscription for element with key '%d' and message name '%s', but no such subscription was found.";
    private final StateWriter stateWriter;
    private final TypedRejectionWriter rejectionWriter;
    private final ProcessInstanceSubscriptionState subscriptionState;

    public ProcessInstanceSubscriptionDeleteProcessor(ProcessInstanceSubscriptionState subscriptionState, Writers writers) {
        this.subscriptionState = subscriptionState;
        this.stateWriter = writers.state();
        this.rejectionWriter = writers.rejection();
    }

    @Override
    public void processRecord(TypedRecord<ProcessInstanceSubscriptionRecord> command, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter) {
        ProcessInstanceSubscriptionRecord subscription = command.getValue();
        boolean exists = this.subscriptionState.existSubscriptionForElementInstance(subscription.getElementInstanceKey(), subscription.getMessageNameBuffer());
        if (exists) {
            this.stateWriter.appendFollowUpEvent(command.getKey(), (Intent)ProcessInstanceSubscriptionIntent.DELETED, (RecordValue)subscription);
        } else {
            this.rejectCommand(command);
        }
    }

    private void rejectCommand(TypedRecord<ProcessInstanceSubscriptionRecord> command) {
        String reason = String.format(NO_SUBSCRIPTION_FOUND_MESSAGE, command.getValue().getElementInstanceKey(), BufferUtil.bufferAsString((DirectBuffer)command.getValue().getMessageNameBuffer()));
        this.rejectionWriter.appendRejection(command, RejectionType.NOT_FOUND, reason);
    }
}

