/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.message.command;

import io.zeebe.engine.processing.message.command.CorrelateMessageSubscriptionDecoder;
import io.zeebe.engine.processing.message.command.CorrelateMessageSubscriptionEncoder;
import io.zeebe.protocol.impl.encoding.SbeBufferWriterReader;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class CorrelateMessageSubscriptionCommand
extends SbeBufferWriterReader<CorrelateMessageSubscriptionEncoder, CorrelateMessageSubscriptionDecoder> {
    private final CorrelateMessageSubscriptionEncoder encoder = new CorrelateMessageSubscriptionEncoder();
    private final CorrelateMessageSubscriptionDecoder decoder = new CorrelateMessageSubscriptionDecoder();
    private final UnsafeBuffer messageName = new UnsafeBuffer(0L, 0);
    private final UnsafeBuffer bpmnProcessId = new UnsafeBuffer(0L, 0);
    private int subscriptionPartitionId;
    private long processInstanceKey;
    private long elementInstanceKey;

    protected CorrelateMessageSubscriptionEncoder getBodyEncoder() {
        return this.encoder;
    }

    protected CorrelateMessageSubscriptionDecoder getBodyDecoder() {
        return this.decoder;
    }

    public void reset() {
        this.subscriptionPartitionId = CorrelateMessageSubscriptionDecoder.subscriptionPartitionIdNullValue();
        this.processInstanceKey = CorrelateMessageSubscriptionDecoder.processInstanceKeyNullValue();
        this.elementInstanceKey = CorrelateMessageSubscriptionDecoder.elementInstanceKeyNullValue();
        this.messageName.wrap(0L, 0);
        this.bpmnProcessId.wrap(0L, 0);
    }

    public int getLength() {
        return super.getLength() + CorrelateMessageSubscriptionDecoder.messageNameHeaderLength() + this.messageName.capacity() + CorrelateMessageSubscriptionDecoder.bpmnProcessIdHeaderLength() + this.bpmnProcessId.capacity();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        super.write(buffer, offset);
        this.encoder.subscriptionPartitionId(this.subscriptionPartitionId).processInstanceKey(this.processInstanceKey).elementInstanceKey(this.elementInstanceKey).putMessageName((DirectBuffer)this.messageName, 0, this.messageName.capacity()).putBpmnProcessId((DirectBuffer)this.bpmnProcessId, 0, this.bpmnProcessId.capacity());
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        super.wrap(buffer, offset, length);
        this.subscriptionPartitionId = this.decoder.subscriptionPartitionId();
        this.processInstanceKey = this.decoder.processInstanceKey();
        this.elementInstanceKey = this.decoder.elementInstanceKey();
        offset = this.decoder.limit();
        int messageNameLength = this.decoder.messageNameLength();
        this.messageName.wrap(buffer, offset += CorrelateMessageSubscriptionDecoder.messageNameHeaderLength(), messageNameLength);
        this.decoder.limit(offset += messageNameLength);
        int bpmnProcessIdLength = this.decoder.bpmnProcessIdLength();
        this.bpmnProcessId.wrap(buffer, offset += CorrelateMessageSubscriptionDecoder.bpmnProcessIdHeaderLength(), bpmnProcessIdLength);
        this.decoder.limit(offset += bpmnProcessIdLength);
    }

    public int getSubscriptionPartitionId() {
        return this.subscriptionPartitionId;
    }

    public void setSubscriptionPartitionId(int subscriptionPartitionId) {
        this.subscriptionPartitionId = subscriptionPartitionId;
    }

    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    public void setProcessInstanceKey(long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
    }

    public long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    public void setElementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
    }

    public DirectBuffer getMessageName() {
        return this.messageName;
    }

    public DirectBuffer getBpmnProcessId() {
        return this.bpmnProcessId;
    }
}

