/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.message.command;

import io.zeebe.engine.processing.message.command.BooleanType;
import io.zeebe.engine.processing.message.command.OpenMessageSubscriptionDecoder;
import io.zeebe.engine.processing.message.command.OpenMessageSubscriptionEncoder;
import io.zeebe.protocol.impl.encoding.SbeBufferWriterReader;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class OpenMessageSubscriptionCommand
extends SbeBufferWriterReader<OpenMessageSubscriptionEncoder, OpenMessageSubscriptionDecoder> {
    private final OpenMessageSubscriptionEncoder encoder = new OpenMessageSubscriptionEncoder();
    private final OpenMessageSubscriptionDecoder decoder = new OpenMessageSubscriptionDecoder();
    private final UnsafeBuffer messageName = new UnsafeBuffer(0L, 0);
    private final UnsafeBuffer correlationKey = new UnsafeBuffer(0L, 0);
    private final UnsafeBuffer bpmnProcessId = new UnsafeBuffer(0L, 0);
    private int subscriptionPartitionId;
    private long processInstanceKey;
    private long elementInstanceKey;
    private boolean closeOnCorrelate;

    protected OpenMessageSubscriptionEncoder getBodyEncoder() {
        return this.encoder;
    }

    protected OpenMessageSubscriptionDecoder getBodyDecoder() {
        return this.decoder;
    }

    public void reset() {
        this.subscriptionPartitionId = OpenMessageSubscriptionDecoder.subscriptionPartitionIdNullValue();
        this.processInstanceKey = OpenMessageSubscriptionDecoder.processInstanceKeyNullValue();
        this.elementInstanceKey = OpenMessageSubscriptionDecoder.elementInstanceKeyNullValue();
        this.messageName.wrap(0L, 0);
        this.correlationKey.wrap(0L, 0);
        this.bpmnProcessId.wrap(0L, 0);
    }

    public int getLength() {
        return super.getLength() + OpenMessageSubscriptionDecoder.messageNameHeaderLength() + this.messageName.capacity() + OpenMessageSubscriptionDecoder.correlationKeyHeaderLength() + this.correlationKey.capacity() + OpenMessageSubscriptionDecoder.bpmnProcessIdHeaderLength() + this.bpmnProcessId.capacity();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        super.write(buffer, offset);
        this.encoder.subscriptionPartitionId(this.subscriptionPartitionId).processInstanceKey(this.processInstanceKey).elementInstanceKey(this.elementInstanceKey).closeOnCorrelate(this.closeOnCorrelate ? BooleanType.TRUE : BooleanType.FALSE).putMessageName((DirectBuffer)this.messageName, 0, this.messageName.capacity()).putCorrelationKey((DirectBuffer)this.correlationKey, 0, this.correlationKey.capacity()).putBpmnProcessId((DirectBuffer)this.bpmnProcessId, 0, this.bpmnProcessId.capacity());
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        super.wrap(buffer, offset, length);
        this.subscriptionPartitionId = this.decoder.subscriptionPartitionId();
        this.processInstanceKey = this.decoder.processInstanceKey();
        this.elementInstanceKey = this.decoder.elementInstanceKey();
        this.closeOnCorrelate = this.decoder.closeOnCorrelate() == BooleanType.TRUE;
        offset = this.decoder.limit();
        int messageNameLength = this.decoder.messageNameLength();
        this.messageName.wrap(buffer, offset += OpenMessageSubscriptionDecoder.messageNameHeaderLength(), messageNameLength);
        this.decoder.limit(offset += messageNameLength);
        int correlationKeyLength = this.decoder.correlationKeyLength();
        this.correlationKey.wrap(buffer, offset += OpenMessageSubscriptionDecoder.correlationKeyHeaderLength(), correlationKeyLength);
        this.decoder.limit(offset += correlationKeyLength);
        int bpmnProcessIdLength = this.decoder.bpmnProcessIdLength();
        this.bpmnProcessId.wrap(buffer, offset += OpenMessageSubscriptionDecoder.bpmnProcessIdHeaderLength(), bpmnProcessIdLength);
        this.decoder.limit(offset += bpmnProcessIdLength);
    }

    public int getSubscriptionPartitionId() {
        return this.subscriptionPartitionId;
    }

    public void setSubscriptionPartitionId(int subscriptionPartitionId) {
        this.subscriptionPartitionId = subscriptionPartitionId;
    }

    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    public void setProcessInstanceKey(long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
    }

    public long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    public void setElementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
    }

    public DirectBuffer getMessageName() {
        return this.messageName;
    }

    public DirectBuffer getCorrelationKey() {
        return this.correlationKey;
    }

    public boolean shouldCloseOnCorrelate() {
        return this.closeOnCorrelate;
    }

    public void setCloseOnCorrelate(boolean closeOnCorrelate) {
        this.closeOnCorrelate = closeOnCorrelate;
    }

    public DirectBuffer getBpmnProcessId() {
        return this.bpmnProcessId;
    }
}

