/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.message.command;

import io.zeebe.engine.processing.message.command.BooleanType;
import io.zeebe.engine.processing.message.command.OpenProcessInstanceSubscriptionDecoder;
import io.zeebe.engine.processing.message.command.OpenProcessInstanceSubscriptionEncoder;
import io.zeebe.protocol.impl.encoding.SbeBufferWriterReader;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class OpenProcessInstanceSubscriptionCommand
extends SbeBufferWriterReader<OpenProcessInstanceSubscriptionEncoder, OpenProcessInstanceSubscriptionDecoder> {
    private final OpenProcessInstanceSubscriptionEncoder encoder = new OpenProcessInstanceSubscriptionEncoder();
    private final OpenProcessInstanceSubscriptionDecoder decoder = new OpenProcessInstanceSubscriptionDecoder();
    private final UnsafeBuffer messageName = new UnsafeBuffer(0L, 0);
    private int subscriptionPartitionId;
    private long processInstanceKey;
    private long elementInstanceKey;
    private boolean closeOnCorrelate;

    protected OpenProcessInstanceSubscriptionEncoder getBodyEncoder() {
        return this.encoder;
    }

    protected OpenProcessInstanceSubscriptionDecoder getBodyDecoder() {
        return this.decoder;
    }

    public void reset() {
        this.subscriptionPartitionId = OpenProcessInstanceSubscriptionDecoder.subscriptionPartitionIdNullValue();
        this.processInstanceKey = OpenProcessInstanceSubscriptionDecoder.processInstanceKeyNullValue();
        this.elementInstanceKey = OpenProcessInstanceSubscriptionDecoder.elementInstanceKeyNullValue();
        this.messageName.wrap(0L, 0);
    }

    public int getLength() {
        return super.getLength() + OpenProcessInstanceSubscriptionDecoder.messageNameHeaderLength() + this.messageName.capacity();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        super.write(buffer, offset);
        this.encoder.subscriptionPartitionId(this.subscriptionPartitionId).processInstanceKey(this.processInstanceKey).elementInstanceKey(this.elementInstanceKey).closeOnCorrelate(this.closeOnCorrelate ? BooleanType.TRUE : BooleanType.FALSE).putMessageName((DirectBuffer)this.messageName, 0, this.messageName.capacity());
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        super.wrap(buffer, offset, length);
        this.subscriptionPartitionId = this.decoder.subscriptionPartitionId();
        this.processInstanceKey = this.decoder.processInstanceKey();
        this.elementInstanceKey = this.decoder.elementInstanceKey();
        this.closeOnCorrelate = this.decoder.closeOnCorrelate() == BooleanType.TRUE;
        offset = this.decoder.limit();
        int messageNameLength = this.decoder.messageNameLength();
        this.messageName.wrap(buffer, offset += OpenProcessInstanceSubscriptionDecoder.messageNameHeaderLength(), messageNameLength);
    }

    public int getSubscriptionPartitionId() {
        return this.subscriptionPartitionId;
    }

    public void setSubscriptionPartitionId(int subscriptionPartitionId) {
        this.subscriptionPartitionId = subscriptionPartitionId;
    }

    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    public void setProcessInstanceKey(long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
    }

    public long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    public void setElementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
    }

    public DirectBuffer getMessageName() {
        return this.messageName;
    }

    public boolean shouldCloseOnCorrelate() {
        return this.closeOnCorrelate;
    }

    public void setCloseOnCorrelate(boolean closeOnCorrelate) {
        this.closeOnCorrelate = closeOnCorrelate;
    }
}

