/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.message.command;

import io.zeebe.engine.processing.message.command.RejectCorrelateMessageSubscriptionDecoder;
import io.zeebe.engine.processing.message.command.RejectCorrelateMessageSubscriptionEncoder;
import io.zeebe.protocol.impl.encoding.SbeBufferWriterReader;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class RejectCorrelateMessageSubscriptionCommand
extends SbeBufferWriterReader<RejectCorrelateMessageSubscriptionEncoder, RejectCorrelateMessageSubscriptionDecoder> {
    private final RejectCorrelateMessageSubscriptionEncoder encoder = new RejectCorrelateMessageSubscriptionEncoder();
    private final RejectCorrelateMessageSubscriptionDecoder decoder = new RejectCorrelateMessageSubscriptionDecoder();
    private final UnsafeBuffer messageName = new UnsafeBuffer(0L, 0);
    private final UnsafeBuffer correlationKey = new UnsafeBuffer(0L, 0);
    private final UnsafeBuffer bpmnProcessId = new UnsafeBuffer(0L, 0);
    private int subscriptionPartitionId;
    private long processInstanceKey;
    private long messageKey;

    protected RejectCorrelateMessageSubscriptionEncoder getBodyEncoder() {
        return this.encoder;
    }

    protected RejectCorrelateMessageSubscriptionDecoder getBodyDecoder() {
        return this.decoder;
    }

    public void reset() {
        this.subscriptionPartitionId = RejectCorrelateMessageSubscriptionDecoder.subscriptionPartitionIdNullValue();
        this.processInstanceKey = RejectCorrelateMessageSubscriptionDecoder.processInstanceKeyNullValue();
        this.messageKey = RejectCorrelateMessageSubscriptionDecoder.messageKeyNullValue();
        this.messageName.wrap(0L, 0);
        this.correlationKey.wrap(0L, 0);
        this.bpmnProcessId.wrap(0L, 0);
    }

    public int getLength() {
        return super.getLength() + RejectCorrelateMessageSubscriptionDecoder.messageNameHeaderLength() + this.messageName.capacity() + RejectCorrelateMessageSubscriptionDecoder.correlationKeyHeaderLength() + this.correlationKey.capacity() + RejectCorrelateMessageSubscriptionDecoder.bpmnProcessIdHeaderLength() + this.bpmnProcessId.capacity();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        super.write(buffer, offset);
        this.encoder.subscriptionPartitionId(this.subscriptionPartitionId).processInstanceKey(this.processInstanceKey).messageKey(this.messageKey).putMessageName((DirectBuffer)this.messageName, 0, this.messageName.capacity()).putCorrelationKey((DirectBuffer)this.correlationKey, 0, this.correlationKey.capacity()).putBpmnProcessId((DirectBuffer)this.bpmnProcessId, 0, this.bpmnProcessId.capacity());
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        super.wrap(buffer, offset, length);
        this.subscriptionPartitionId = this.decoder.subscriptionPartitionId();
        this.processInstanceKey = this.decoder.processInstanceKey();
        this.messageKey = this.decoder.messageKey();
        this.decoder.wrapMessageName((DirectBuffer)this.messageName);
        this.decoder.wrapCorrelationKey((DirectBuffer)this.correlationKey);
        this.decoder.wrapBpmnProcessId((DirectBuffer)this.bpmnProcessId);
    }

    public int getSubscriptionPartitionId() {
        return this.subscriptionPartitionId;
    }

    public void setSubscriptionPartitionId(int subscriptionPartitionId) {
        this.subscriptionPartitionId = subscriptionPartitionId;
    }

    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    public void setProcessInstanceKey(long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
    }

    public long getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(long messageKey) {
        this.messageKey = messageKey;
    }

    public DirectBuffer getMessageName() {
        return this.messageName;
    }

    public DirectBuffer getCorrelationKey() {
        return this.correlationKey;
    }

    public DirectBuffer getBpmnProcessId() {
        return this.bpmnProcessId;
    }
}

