/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.message.command;

import io.zeebe.engine.processing.message.command.CloseMessageSubscriptionCommand;
import io.zeebe.engine.processing.message.command.CloseProcessInstanceSubscriptionCommand;
import io.zeebe.engine.processing.message.command.CorrelateMessageSubscriptionCommand;
import io.zeebe.engine.processing.message.command.CorrelateProcessInstanceSubscriptionCommand;
import io.zeebe.engine.processing.message.command.MessageHeaderDecoder;
import io.zeebe.engine.processing.message.command.OpenMessageSubscriptionCommand;
import io.zeebe.engine.processing.message.command.OpenProcessInstanceSubscriptionCommand;
import io.zeebe.engine.processing.message.command.RejectCorrelateMessageSubscriptionCommand;
import io.zeebe.logstreams.log.LogStreamRecordWriter;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.Protocol;
import io.zeebe.protocol.impl.record.RecordMetadata;
import io.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.zeebe.protocol.impl.record.value.message.ProcessInstanceSubscriptionRecord;
import io.zeebe.protocol.record.RecordType;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.zeebe.protocol.record.intent.ProcessInstanceSubscriptionIntent;
import io.zeebe.util.buffer.BufferWriter;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class SubscriptionCommandMessageHandler
implements Function<byte[], CompletableFuture<Void>> {
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final OpenMessageSubscriptionCommand openMessageSubscriptionCommand = new OpenMessageSubscriptionCommand();
    private final OpenProcessInstanceSubscriptionCommand openProcessInstanceSubscriptionCommand = new OpenProcessInstanceSubscriptionCommand();
    private final CorrelateProcessInstanceSubscriptionCommand correlateProcessInstanceSubscriptionCommand = new CorrelateProcessInstanceSubscriptionCommand();
    private final CorrelateMessageSubscriptionCommand correlateMessageSubscriptionCommand = new CorrelateMessageSubscriptionCommand();
    private final CloseMessageSubscriptionCommand closeMessageSubscriptionCommand = new CloseMessageSubscriptionCommand();
    private final CloseProcessInstanceSubscriptionCommand closeProcessInstanceSubscriptionCommand = new CloseProcessInstanceSubscriptionCommand();
    private final RejectCorrelateMessageSubscriptionCommand resetMessageCorrelationCommand = new RejectCorrelateMessageSubscriptionCommand();
    private final RecordMetadata recordMetadata = new RecordMetadata();
    private final MessageSubscriptionRecord messageSubscriptionRecord = new MessageSubscriptionRecord();
    private final ProcessInstanceSubscriptionRecord processInstanceSubscriptionRecord = new ProcessInstanceSubscriptionRecord();
    private final Consumer<Runnable> enviromentToRun;
    private final IntFunction<LogStreamRecordWriter> logstreamRecordWriterSupplier;

    public SubscriptionCommandMessageHandler(Consumer<Runnable> enviromentToRun, IntFunction<LogStreamRecordWriter> logstreamRecordWriterSupplier) {
        this.enviromentToRun = enviromentToRun;
        this.logstreamRecordWriterSupplier = logstreamRecordWriterSupplier;
    }

    @Override
    public CompletableFuture<Void> apply(byte[] bytes) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.enviromentToRun.accept(() -> {
            UnsafeBuffer buffer = new UnsafeBuffer(bytes);
            boolean offset = false;
            int length = buffer.capacity();
            this.messageHeaderDecoder.wrap((DirectBuffer)buffer, 0);
            if (this.messageHeaderDecoder.schemaId() == 6) {
                switch (this.messageHeaderDecoder.templateId()) {
                    case 0: {
                        this.onOpenMessageSubscription((DirectBuffer)buffer, 0, length);
                        break;
                    }
                    case 1: {
                        this.onOpenProcessInstanceSubscription((DirectBuffer)buffer, 0, length);
                        break;
                    }
                    case 2: {
                        this.onCorrelateProcessInstanceSubscription((DirectBuffer)buffer, 0, length);
                        break;
                    }
                    case 3: {
                        this.onCorrelateMessageSubscription((DirectBuffer)buffer, 0, length);
                        break;
                    }
                    case 4: {
                        this.onCloseMessageSubscription((DirectBuffer)buffer, 0, length);
                        break;
                    }
                    case 5: {
                        this.onCloseProcessInstanceSubscription((DirectBuffer)buffer, 0, length);
                        break;
                    }
                    case 6: {
                        this.onRejectCorrelateMessageSubscription((DirectBuffer)buffer, 0, length);
                        break;
                    }
                }
            }
            future.complete(null);
        });
        return future;
    }

    private boolean onOpenMessageSubscription(DirectBuffer buffer, int offset, int length) {
        this.openMessageSubscriptionCommand.wrap(buffer, offset, length);
        this.messageSubscriptionRecord.setProcessInstanceKey(this.openMessageSubscriptionCommand.getProcessInstanceKey()).setElementInstanceKey(this.openMessageSubscriptionCommand.getElementInstanceKey()).setBpmnProcessId(this.openMessageSubscriptionCommand.getBpmnProcessId()).setMessageKey(-1L).setMessageName(this.openMessageSubscriptionCommand.getMessageName()).setCorrelationKey(this.openMessageSubscriptionCommand.getCorrelationKey()).setInterrupting(this.openMessageSubscriptionCommand.shouldCloseOnCorrelate());
        return this.writeCommand(this.openMessageSubscriptionCommand.getSubscriptionPartitionId(), ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.CREATE, (UnpackedObject)this.messageSubscriptionRecord);
    }

    private boolean onOpenProcessInstanceSubscription(DirectBuffer buffer, int offset, int length) {
        this.openProcessInstanceSubscriptionCommand.wrap(buffer, offset, length);
        long processInstanceKey = this.openProcessInstanceSubscriptionCommand.getProcessInstanceKey();
        int processInstancePartitionId = Protocol.decodePartitionId((long)processInstanceKey);
        this.processInstanceSubscriptionRecord.reset();
        this.processInstanceSubscriptionRecord.setSubscriptionPartitionId(this.openProcessInstanceSubscriptionCommand.getSubscriptionPartitionId()).setProcessInstanceKey(processInstanceKey).setElementInstanceKey(this.openProcessInstanceSubscriptionCommand.getElementInstanceKey()).setMessageKey(-1L).setMessageName(this.openProcessInstanceSubscriptionCommand.getMessageName()).setInterrupting(this.openProcessInstanceSubscriptionCommand.shouldCloseOnCorrelate());
        return this.writeCommand(processInstancePartitionId, ValueType.PROCESS_INSTANCE_SUBSCRIPTION, (Intent)ProcessInstanceSubscriptionIntent.CREATE, (UnpackedObject)this.processInstanceSubscriptionRecord);
    }

    private boolean onCorrelateProcessInstanceSubscription(DirectBuffer buffer, int offset, int length) {
        this.correlateProcessInstanceSubscriptionCommand.wrap(buffer, offset, length);
        long processInstanceKey = this.correlateProcessInstanceSubscriptionCommand.getProcessInstanceKey();
        int processInstancePartitionId = Protocol.decodePartitionId((long)processInstanceKey);
        this.processInstanceSubscriptionRecord.setSubscriptionPartitionId(this.correlateProcessInstanceSubscriptionCommand.getSubscriptionPartitionId()).setProcessInstanceKey(processInstanceKey).setElementInstanceKey(this.correlateProcessInstanceSubscriptionCommand.getElementInstanceKey()).setBpmnProcessId(this.correlateProcessInstanceSubscriptionCommand.getBpmnProcessId()).setMessageKey(this.correlateProcessInstanceSubscriptionCommand.getMessageKey()).setMessageName(this.correlateProcessInstanceSubscriptionCommand.getMessageName()).setVariables(this.correlateProcessInstanceSubscriptionCommand.getVariables()).setCorrelationKey(this.correlateProcessInstanceSubscriptionCommand.getCorrelationKey());
        return this.writeCommand(processInstancePartitionId, ValueType.PROCESS_INSTANCE_SUBSCRIPTION, (Intent)ProcessInstanceSubscriptionIntent.CORRELATE, (UnpackedObject)this.processInstanceSubscriptionRecord);
    }

    private boolean onCorrelateMessageSubscription(DirectBuffer buffer, int offset, int length) {
        this.correlateMessageSubscriptionCommand.wrap(buffer, offset, length);
        this.messageSubscriptionRecord.reset();
        this.messageSubscriptionRecord.setProcessInstanceKey(this.correlateMessageSubscriptionCommand.getProcessInstanceKey()).setElementInstanceKey(this.correlateMessageSubscriptionCommand.getElementInstanceKey()).setBpmnProcessId(this.correlateMessageSubscriptionCommand.getBpmnProcessId()).setMessageKey(-1L).setMessageName(this.correlateMessageSubscriptionCommand.getMessageName());
        return this.writeCommand(this.correlateMessageSubscriptionCommand.getSubscriptionPartitionId(), ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.CORRELATE, (UnpackedObject)this.messageSubscriptionRecord);
    }

    private boolean onCloseMessageSubscription(DirectBuffer buffer, int offset, int length) {
        this.closeMessageSubscriptionCommand.wrap(buffer, offset, length);
        this.messageSubscriptionRecord.reset();
        this.messageSubscriptionRecord.setProcessInstanceKey(this.closeMessageSubscriptionCommand.getProcessInstanceKey()).setElementInstanceKey(this.closeMessageSubscriptionCommand.getElementInstanceKey()).setMessageKey(-1L).setMessageName(this.closeMessageSubscriptionCommand.getMessageName());
        return this.writeCommand(this.closeMessageSubscriptionCommand.getSubscriptionPartitionId(), ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.DELETE, (UnpackedObject)this.messageSubscriptionRecord);
    }

    private boolean onCloseProcessInstanceSubscription(DirectBuffer buffer, int offset, int length) {
        this.closeProcessInstanceSubscriptionCommand.wrap(buffer, offset, length);
        long processInstanceKey = this.closeProcessInstanceSubscriptionCommand.getProcessInstanceKey();
        int processInstancePartitionId = Protocol.decodePartitionId((long)processInstanceKey);
        this.processInstanceSubscriptionRecord.reset();
        this.processInstanceSubscriptionRecord.setSubscriptionPartitionId(this.closeProcessInstanceSubscriptionCommand.getSubscriptionPartitionId()).setProcessInstanceKey(processInstanceKey).setElementInstanceKey(this.closeProcessInstanceSubscriptionCommand.getElementInstanceKey()).setMessageKey(-1L).setMessageName(this.closeProcessInstanceSubscriptionCommand.getMessageName());
        return this.writeCommand(processInstancePartitionId, ValueType.PROCESS_INSTANCE_SUBSCRIPTION, (Intent)ProcessInstanceSubscriptionIntent.DELETE, (UnpackedObject)this.processInstanceSubscriptionRecord);
    }

    private boolean onRejectCorrelateMessageSubscription(DirectBuffer buffer, int offset, int length) {
        this.resetMessageCorrelationCommand.wrap(buffer, offset, length);
        long processInstanceKey = this.resetMessageCorrelationCommand.getProcessInstanceKey();
        this.messageSubscriptionRecord.reset();
        this.messageSubscriptionRecord.setProcessInstanceKey(processInstanceKey).setElementInstanceKey(-1L).setBpmnProcessId(this.resetMessageCorrelationCommand.getBpmnProcessId()).setMessageName(this.resetMessageCorrelationCommand.getMessageName()).setCorrelationKey(this.resetMessageCorrelationCommand.getCorrelationKey()).setMessageKey(this.resetMessageCorrelationCommand.getMessageKey()).setInterrupting(false);
        return this.writeCommand(this.resetMessageCorrelationCommand.getSubscriptionPartitionId(), ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.REJECT, (UnpackedObject)this.messageSubscriptionRecord);
    }

    private boolean writeCommand(int partitionId, ValueType valueType, Intent intent, UnpackedObject command) {
        LogStreamRecordWriter logStreamRecordWriter = this.logstreamRecordWriterSupplier.apply(partitionId);
        if (logStreamRecordWriter == null) {
            return true;
        }
        logStreamRecordWriter.reset();
        this.recordMetadata.reset().recordType(RecordType.COMMAND).valueType(valueType).intent(intent);
        long position = logStreamRecordWriter.key(-1L).metadataWriter((BufferWriter)this.recordMetadata).valueWriter((BufferWriter)command).tryWrite();
        return position > 0L;
    }
}

