/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.message.command;

import io.zeebe.engine.processing.message.command.CloseMessageSubscriptionCommand;
import io.zeebe.engine.processing.message.command.CloseProcessInstanceSubscriptionCommand;
import io.zeebe.engine.processing.message.command.CorrelateMessageSubscriptionCommand;
import io.zeebe.engine.processing.message.command.CorrelateProcessInstanceSubscriptionCommand;
import io.zeebe.engine.processing.message.command.OpenMessageSubscriptionCommand;
import io.zeebe.engine.processing.message.command.OpenProcessInstanceSubscriptionCommand;
import io.zeebe.engine.processing.message.command.PartitionCommandSender;
import io.zeebe.engine.processing.message.command.RejectCorrelateMessageSubscriptionCommand;
import io.zeebe.protocol.Protocol;
import io.zeebe.util.buffer.BufferWriter;
import org.agrona.DirectBuffer;

public class SubscriptionCommandSender {
    private final OpenMessageSubscriptionCommand openMessageSubscriptionCommand = new OpenMessageSubscriptionCommand();
    private final OpenProcessInstanceSubscriptionCommand openProcessInstanceSubscriptionCommand = new OpenProcessInstanceSubscriptionCommand();
    private final CorrelateProcessInstanceSubscriptionCommand correlateProcessInstanceSubscriptionCommand = new CorrelateProcessInstanceSubscriptionCommand();
    private final CorrelateMessageSubscriptionCommand correlateMessageSubscriptionCommand = new CorrelateMessageSubscriptionCommand();
    private final CloseMessageSubscriptionCommand closeMessageSubscriptionCommand = new CloseMessageSubscriptionCommand();
    private final CloseProcessInstanceSubscriptionCommand closeProcessInstanceSubscriptionCommand = new CloseProcessInstanceSubscriptionCommand();
    private final RejectCorrelateMessageSubscriptionCommand rejectCorrelateMessageSubscriptionCommand = new RejectCorrelateMessageSubscriptionCommand();
    private final PartitionCommandSender partitionCommandSender;
    private final int senderPartition;

    public SubscriptionCommandSender(int senderPartition, PartitionCommandSender partitionCommandSender) {
        this.senderPartition = senderPartition;
        this.partitionCommandSender = partitionCommandSender;
    }

    public boolean openMessageSubscription(int subscriptionPartitionId, long processInstanceKey, long elementInstanceKey, DirectBuffer bpmnProcessId, DirectBuffer messageName, DirectBuffer correlationKey, boolean closeOnCorrelate) {
        this.openMessageSubscriptionCommand.setSubscriptionPartitionId(subscriptionPartitionId);
        this.openMessageSubscriptionCommand.setProcessInstanceKey(processInstanceKey);
        this.openMessageSubscriptionCommand.setElementInstanceKey(elementInstanceKey);
        this.openMessageSubscriptionCommand.getBpmnProcessId().wrap(bpmnProcessId);
        this.openMessageSubscriptionCommand.getMessageName().wrap(messageName);
        this.openMessageSubscriptionCommand.getCorrelationKey().wrap(correlationKey);
        this.openMessageSubscriptionCommand.setCloseOnCorrelate(closeOnCorrelate);
        return this.partitionCommandSender.sendCommand(subscriptionPartitionId, (BufferWriter)this.openMessageSubscriptionCommand);
    }

    public boolean openProcessInstanceSubscription(long processInstanceKey, long elementInstanceKey, DirectBuffer messageName, boolean closeOnCorrelate) {
        int processInstancePartitionId = Protocol.decodePartitionId((long)processInstanceKey);
        this.openProcessInstanceSubscriptionCommand.setSubscriptionPartitionId(this.senderPartition);
        this.openProcessInstanceSubscriptionCommand.setProcessInstanceKey(processInstanceKey);
        this.openProcessInstanceSubscriptionCommand.setElementInstanceKey(elementInstanceKey);
        this.openProcessInstanceSubscriptionCommand.getMessageName().wrap(messageName);
        this.openProcessInstanceSubscriptionCommand.setCloseOnCorrelate(closeOnCorrelate);
        return this.partitionCommandSender.sendCommand(processInstancePartitionId, (BufferWriter)this.openProcessInstanceSubscriptionCommand);
    }

    public boolean correlateProcessInstanceSubscription(long processInstanceKey, long elementInstanceKey, DirectBuffer bpmnProcessId, DirectBuffer messageName, long messageKey, DirectBuffer variables, DirectBuffer correlationKey) {
        int processInstancePartitionId = Protocol.decodePartitionId((long)processInstanceKey);
        this.correlateProcessInstanceSubscriptionCommand.setSubscriptionPartitionId(this.senderPartition);
        this.correlateProcessInstanceSubscriptionCommand.setProcessInstanceKey(processInstanceKey);
        this.correlateProcessInstanceSubscriptionCommand.setElementInstanceKey(elementInstanceKey);
        this.correlateProcessInstanceSubscriptionCommand.getBpmnProcessId().wrap(bpmnProcessId);
        this.correlateProcessInstanceSubscriptionCommand.setMessageKey(messageKey);
        this.correlateProcessInstanceSubscriptionCommand.getMessageName().wrap(messageName);
        this.correlateProcessInstanceSubscriptionCommand.getVariables().wrap(variables);
        this.correlateProcessInstanceSubscriptionCommand.getCorrelationKey().wrap(correlationKey);
        return this.partitionCommandSender.sendCommand(processInstancePartitionId, (BufferWriter)this.correlateProcessInstanceSubscriptionCommand);
    }

    public boolean correlateMessageSubscription(int subscriptionPartitionId, long processInstanceKey, long elementInstanceKey, DirectBuffer bpmnProcessId, DirectBuffer messageName) {
        this.correlateMessageSubscriptionCommand.setSubscriptionPartitionId(subscriptionPartitionId);
        this.correlateMessageSubscriptionCommand.setProcessInstanceKey(processInstanceKey);
        this.correlateMessageSubscriptionCommand.setElementInstanceKey(elementInstanceKey);
        this.correlateMessageSubscriptionCommand.getBpmnProcessId().wrap(bpmnProcessId);
        this.correlateMessageSubscriptionCommand.getMessageName().wrap(messageName);
        return this.partitionCommandSender.sendCommand(subscriptionPartitionId, (BufferWriter)this.correlateMessageSubscriptionCommand);
    }

    public boolean closeMessageSubscription(int subscriptionPartitionId, long processInstanceKey, long elementInstanceKey, DirectBuffer messageName) {
        this.closeMessageSubscriptionCommand.setSubscriptionPartitionId(subscriptionPartitionId);
        this.closeMessageSubscriptionCommand.setProcessInstanceKey(processInstanceKey);
        this.closeMessageSubscriptionCommand.setElementInstanceKey(elementInstanceKey);
        this.closeMessageSubscriptionCommand.setMessageName(messageName);
        return this.partitionCommandSender.sendCommand(subscriptionPartitionId, (BufferWriter)this.closeMessageSubscriptionCommand);
    }

    public boolean closeProcessInstanceSubscription(long processInstanceKey, long elementInstanceKey, DirectBuffer messageName) {
        int processInstancePartitionId = Protocol.decodePartitionId((long)processInstanceKey);
        this.closeProcessInstanceSubscriptionCommand.setSubscriptionPartitionId(this.senderPartition);
        this.closeProcessInstanceSubscriptionCommand.setProcessInstanceKey(processInstanceKey);
        this.closeProcessInstanceSubscriptionCommand.setElementInstanceKey(elementInstanceKey);
        this.closeProcessInstanceSubscriptionCommand.setMessageName(messageName);
        return this.partitionCommandSender.sendCommand(processInstancePartitionId, (BufferWriter)this.closeProcessInstanceSubscriptionCommand);
    }

    public boolean rejectCorrelateMessageSubscription(long processInstanceKey, DirectBuffer bpmnProcessId, long messageKey, DirectBuffer messageName, DirectBuffer correlationKey) {
        int processInstancePartitionId = Protocol.decodePartitionId((long)processInstanceKey);
        this.rejectCorrelateMessageSubscriptionCommand.setSubscriptionPartitionId(this.senderPartition);
        this.rejectCorrelateMessageSubscriptionCommand.setProcessInstanceKey(processInstanceKey);
        this.rejectCorrelateMessageSubscriptionCommand.getBpmnProcessId().wrap(bpmnProcessId);
        this.rejectCorrelateMessageSubscriptionCommand.setMessageKey(messageKey);
        this.rejectCorrelateMessageSubscriptionCommand.getMessageName().wrap(messageName);
        this.rejectCorrelateMessageSubscriptionCommand.getCorrelationKey().wrap(correlationKey);
        return this.partitionCommandSender.sendCommand(processInstancePartitionId, (BufferWriter)this.rejectCorrelateMessageSubscriptionCommand);
    }
}

