/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.streamprocessor;

import io.zeebe.engine.processing.streamprocessor.CommandProcessor;
import io.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.zeebe.engine.state.KeyGenerator;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;

public final class CommandProcessorImpl<T extends UnifiedRecordValue>
implements TypedRecordProcessor<T>,
CommandProcessor.CommandControl<T> {
    private final CommandProcessor<T> wrappedProcessor;
    private final KeyGenerator keyGenerator;
    private final StateWriter stateWriter;
    private final TypedRejectionWriter rejectionWriter;
    private final TypedCommandWriter commandWriter;
    private boolean isAccepted;
    private long entityKey;
    private Intent newState;
    private T updatedValue;
    private RejectionType rejectionType;
    private String rejectionReason;

    public CommandProcessorImpl(CommandProcessor<T> commandProcessor, KeyGenerator keyGenerator, Writers writers) {
        this.wrappedProcessor = commandProcessor;
        this.keyGenerator = keyGenerator;
        this.stateWriter = writers.state();
        this.commandWriter = writers.command();
        this.rejectionWriter = writers.rejection();
    }

    @Override
    public void processRecord(TypedRecord<T> command, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter) {
        boolean respond;
        this.entityKey = command.getKey();
        boolean shouldRespond = this.wrappedProcessor.onCommand(command, this);
        boolean bl = respond = shouldRespond && command.hasRequestMetadata();
        if (this.isAccepted) {
            this.stateWriter.appendFollowUpEvent(this.entityKey, this.newState, (RecordValue)this.updatedValue);
            this.wrappedProcessor.afterAccept(this.commandWriter, this.stateWriter, this.entityKey, this.newState, this.updatedValue);
            if (respond) {
                responseWriter.writeEventOnCommand(this.entityKey, this.newState, (UnpackedObject)this.updatedValue, command);
            }
        } else {
            this.rejectionWriter.appendRejection(command, this.rejectionType, this.rejectionReason);
            if (respond) {
                responseWriter.writeRejectionOnCommand(command, this.rejectionType, this.rejectionReason);
            }
        }
    }

    @Override
    public long accept(Intent newState, T updatedValue) {
        if (this.entityKey < 0L) {
            this.entityKey = this.keyGenerator.nextKey();
        }
        this.isAccepted = true;
        this.newState = newState;
        this.updatedValue = updatedValue;
        return this.entityKey;
    }

    @Override
    public void reject(RejectionType type, String reason) {
        this.isAccepted = false;
        this.rejectionType = type;
        this.rejectionReason = reason;
    }
}

