/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.streamprocessor;

import io.zeebe.db.TransactionContext;
import io.zeebe.engine.processing.streamprocessor.ReadonlyProcessingContext;
import io.zeebe.engine.processing.streamprocessor.RecordProcessorMap;
import io.zeebe.engine.processing.streamprocessor.RecordValues;
import io.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.zeebe.engine.processing.streamprocessor.writers.CommandResponseWriter;
import io.zeebe.engine.processing.streamprocessor.writers.EventApplyingStateWriter;
import io.zeebe.engine.processing.streamprocessor.writers.NoopTypedStreamWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriterImpl;
import io.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.zeebe.engine.state.EventApplier;
import io.zeebe.engine.state.KeyGeneratorControls;
import io.zeebe.engine.state.ZeebeDbState;
import io.zeebe.engine.state.mutable.MutableLastProcessedPositionState;
import io.zeebe.engine.state.mutable.MutableZeebeState;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.logstreams.log.LogStreamReader;
import io.zeebe.logstreams.log.LoggedEvent;
import io.zeebe.util.sched.ActorControl;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;

public final class ProcessingContext
implements ReadonlyProcessingContext {
    private ActorControl actor;
    private LogStream logStream;
    private LogStreamReader logStreamReader;
    private TypedStreamWriter logStreamWriter = new NoopTypedStreamWriter();
    private CommandResponseWriter commandResponseWriter;
    private TypedResponseWriterImpl typedResponseWriter;
    private RecordValues recordValues;
    private RecordProcessorMap recordProcessorMap;
    private ZeebeDbState zeebeState;
    private TransactionContext transactionContext;
    private EventApplier eventApplier;
    private BooleanSupplier abortCondition;
    private Consumer<TypedRecord> onProcessedListener = record -> {};
    private Consumer<LoggedEvent> onSkippedListener = record -> {};
    private int maxFragmentSize;
    private boolean detectReprocessingInconsistency;

    public ProcessingContext actor(ActorControl actor) {
        this.actor = actor;
        return this;
    }

    public ProcessingContext logStream(LogStream logStream) {
        this.logStream = logStream;
        return this;
    }

    public ProcessingContext logStreamReader(LogStreamReader logStreamReader) {
        this.logStreamReader = logStreamReader;
        return this;
    }

    public ProcessingContext eventCache(RecordValues recordValues) {
        this.recordValues = recordValues;
        return this;
    }

    public ProcessingContext recordProcessorMap(RecordProcessorMap recordProcessorMap) {
        this.recordProcessorMap = recordProcessorMap;
        return this;
    }

    public ProcessingContext zeebeState(ZeebeDbState zeebeState) {
        this.zeebeState = zeebeState;
        return this;
    }

    public ProcessingContext transactionContext(TransactionContext transactionContext) {
        this.transactionContext = transactionContext;
        return this;
    }

    public ProcessingContext abortCondition(BooleanSupplier abortCondition) {
        this.abortCondition = abortCondition;
        return this;
    }

    public ProcessingContext logStreamWriter(TypedStreamWriter logStreamWriter) {
        this.logStreamWriter = logStreamWriter;
        return this;
    }

    public ProcessingContext commandResponseWriter(CommandResponseWriter commandResponseWriter) {
        this.commandResponseWriter = commandResponseWriter;
        this.typedResponseWriter = new TypedResponseWriterImpl(commandResponseWriter, this.getLogStream().getPartitionId());
        return this;
    }

    public CommandResponseWriter getCommandResponseWriter() {
        return this.commandResponseWriter;
    }

    public ProcessingContext onProcessedListener(Consumer<TypedRecord> onProcessedListener) {
        this.onProcessedListener = onProcessedListener;
        return this;
    }

    public ProcessingContext onSkippedListener(Consumer<LoggedEvent> onSkippedListener) {
        this.onSkippedListener = onSkippedListener;
        return this;
    }

    public ProcessingContext maxFragmentSize(int maxFragmentSize) {
        this.maxFragmentSize = maxFragmentSize;
        return this;
    }

    public ProcessingContext eventApplier(EventApplier eventApplier) {
        this.eventApplier = eventApplier;
        return this;
    }

    public KeyGeneratorControls getKeyGeneratorControls() {
        return this.zeebeState.getKeyGeneratorControls();
    }

    public MutableLastProcessedPositionState getLastProcessedPositionState() {
        return this.zeebeState.getLastProcessedPositionState();
    }

    @Override
    public ActorControl getActor() {
        return this.actor;
    }

    @Override
    public LogStream getLogStream() {
        return this.logStream;
    }

    @Override
    public LogStreamReader getLogStreamReader() {
        return this.logStreamReader;
    }

    @Override
    public int getMaxFragmentSize() {
        return this.maxFragmentSize;
    }

    @Override
    public TypedStreamWriter getLogStreamWriter() {
        return this.logStreamWriter;
    }

    @Override
    public Writers getWriters() {
        EventApplyingStateWriter stateWriter = new EventApplyingStateWriter(this.logStreamWriter, this.eventApplier);
        return new Writers(this.logStreamWriter, stateWriter, this.typedResponseWriter);
    }

    @Override
    public RecordValues getRecordValues() {
        return this.recordValues;
    }

    @Override
    public RecordProcessorMap getRecordProcessorMap() {
        return this.recordProcessorMap;
    }

    @Override
    public MutableZeebeState getZeebeState() {
        return this.zeebeState;
    }

    @Override
    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    @Override
    public BooleanSupplier getAbortCondition() {
        return this.abortCondition;
    }

    @Override
    public EventApplier getEventApplier() {
        return this.eventApplier;
    }

    public Consumer<TypedRecord> getOnProcessedListener() {
        return this.onProcessedListener;
    }

    public Consumer<LoggedEvent> getOnSkippedListener() {
        return this.onSkippedListener;
    }

    public boolean isDetectReprocessingInconsistency() {
        return this.detectReprocessingInconsistency;
    }

    public ProcessingContext setDetectReprocessingInconsistency(boolean detectReprocessingInconsistency) {
        this.detectReprocessingInconsistency = detectReprocessingInconsistency;
        return this;
    }
}

