/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.streamprocessor;

import io.zeebe.db.TransactionContext;
import io.zeebe.db.ZeebeDbTransaction;
import io.zeebe.engine.metrics.StreamProcessorMetrics;
import io.zeebe.engine.processing.streamprocessor.EventFilter;
import io.zeebe.engine.processing.streamprocessor.MetadataEventFilter;
import io.zeebe.engine.processing.streamprocessor.MetadataFilter;
import io.zeebe.engine.processing.streamprocessor.MigratedStreamProcessors;
import io.zeebe.engine.processing.streamprocessor.ProcessingContext;
import io.zeebe.engine.processing.streamprocessor.RecordProcessorMap;
import io.zeebe.engine.processing.streamprocessor.RecordProtocolVersionFilter;
import io.zeebe.engine.processing.streamprocessor.RecordValues;
import io.zeebe.engine.processing.streamprocessor.TypedEventImpl;
import io.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.zeebe.engine.processing.streamprocessor.sideeffect.SideEffectProducer;
import io.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.zeebe.engine.state.mutable.MutableLastProcessedPositionState;
import io.zeebe.engine.state.mutable.MutableZeebeState;
import io.zeebe.logstreams.impl.Loggers;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.logstreams.log.LogStreamReader;
import io.zeebe.logstreams.log.LoggedEvent;
import io.zeebe.protocol.impl.record.RecordMetadata;
import io.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.zeebe.protocol.impl.record.value.error.ErrorRecord;
import io.zeebe.protocol.record.RecordType;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.ErrorIntent;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.util.buffer.BufferReader;
import io.zeebe.util.exception.RecoverableException;
import io.zeebe.util.retry.AbortableRetryStrategy;
import io.zeebe.util.retry.RecoverableRetryStrategy;
import io.zeebe.util.retry.RetryStrategy;
import io.zeebe.util.sched.ActorControl;
import io.zeebe.util.sched.clock.ActorClock;
import io.zeebe.util.sched.future.ActorFuture;
import java.time.Duration;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.slf4j.Logger;

public final class ProcessingStateMachine {
    public static final String ERROR_MESSAGE_WRITE_EVENT_ABORTED = "Expected to write one or more follow up events for event '{}' without errors, but exception was thrown.";
    private static final Logger LOG = Loggers.PROCESSOR_LOGGER;
    private static final String ERROR_MESSAGE_ROLLBACK_ABORTED = "Expected to roll back the current transaction for event '{}' successfully, but exception was thrown.";
    private static final String ERROR_MESSAGE_EXECUTE_SIDE_EFFECT_ABORTED = "Expected to execute side effects for event '{}' successfully, but exception was thrown.";
    private static final String ERROR_MESSAGE_UPDATE_STATE_FAILED = "Expected to successfully update state for event '{}', but caught an exception. Retry.";
    private static final String ERROR_MESSAGE_ON_EVENT_FAILED_SKIP_EVENT = "Expected to find event processor for event '{}', but caught an exception. Skip this event.";
    private static final String ERROR_MESSAGE_PROCESSING_FAILED_SKIP_EVENT = "Expected to successfully process event '{}' with processor, but caught an exception. Skip this event.";
    private static final String ERROR_MESSAGE_PROCESSING_FAILED_RETRY_PROCESSING = "Expected to process event '{}' successfully on stream processor, but caught recoverable exception. Retry processing.";
    private static final String PROCESSING_ERROR_MESSAGE = "Expected to process event '%s' without errors, but exception occurred with message '%s' .";
    private static final String NOTIFY_PROCESSED_LISTENER_ERROR_MESSAGE = "Expected to invoke processed listener for record {} successfully, but exception was thrown.";
    private static final String NOTIFY_SKIPPED_LISTENER_ERROR_MESSAGE = "Expected to invoke skipped listener for record {} successfully, but exception was thrown.";
    private static final String LOG_ERROR_EVENT_COMMITTED = "Error event was committed, we continue with processing.";
    private static final String LOG_ERROR_EVENT_WRITTEN = "Error record was written at {}, we will continue with processing if event was committed. Current commit position is {}.";
    private static final Duration PROCESSING_RETRY_DELAY = Duration.ofMillis(250L);
    private static final MetadataFilter PROCESSING_FILTER = recordMetadata -> recordMetadata.getRecordType() == RecordType.COMMAND || !MigratedStreamProcessors.isMigrated(recordMetadata.getValueType());
    private final EventFilter eventFilter = new MetadataEventFilter(new RecordProtocolVersionFilter().and(PROCESSING_FILTER));
    private final MutableZeebeState zeebeState;
    private final MutableLastProcessedPositionState lastProcessedPositionState;
    private final RecordMetadata metadata = new RecordMetadata();
    private final TypedResponseWriter responseWriter;
    private final ActorControl actor;
    private final LogStream logStream;
    private final LogStreamReader logStreamReader;
    private final TypedStreamWriter logStreamWriter;
    private final TransactionContext transactionContext;
    private final RetryStrategy writeRetryStrategy;
    private final RetryStrategy sideEffectsRetryStrategy;
    private final RetryStrategy updateStateRetryStrategy;
    private final BooleanSupplier shouldProcessNext;
    private final BooleanSupplier abortCondition;
    private final ErrorRecord errorRecord = new ErrorRecord();
    private final RecordValues recordValues;
    private final RecordProcessorMap recordProcessorMap;
    private final TypedEventImpl typedEvent;
    private final StreamProcessorMetrics metrics;
    private final Consumer<TypedRecord> onProcessedListener;
    private final Consumer<LoggedEvent> onSkippedListener;
    private SideEffectProducer sideEffectProducer;
    private LoggedEvent currentEvent;
    private TypedRecordProcessor<?> currentProcessor;
    private ZeebeDbTransaction zeebeDbTransaction;
    private long writtenEventPosition = -1L;
    private long lastSuccessfulProcessedEventPosition = -1L;
    private long lastWrittenEventPosition = -1L;
    private boolean onErrorHandling;
    private long errorRecordPosition = -1L;
    private volatile boolean onErrorHandlingLoop;
    private int onErrorRetries;
    private long processingStartTime;

    public ProcessingStateMachine(ProcessingContext context, BooleanSupplier shouldProcessNext) {
        this.actor = context.getActor();
        this.recordProcessorMap = context.getRecordProcessorMap();
        this.recordValues = context.getRecordValues();
        this.logStreamReader = context.getLogStreamReader();
        this.logStreamWriter = context.getLogStreamWriter();
        this.logStream = context.getLogStream();
        this.zeebeState = context.getZeebeState();
        this.transactionContext = context.getTransactionContext();
        this.abortCondition = context.getAbortCondition();
        this.lastProcessedPositionState = context.getLastProcessedPositionState();
        this.writeRetryStrategy = new AbortableRetryStrategy(this.actor);
        this.sideEffectsRetryStrategy = new AbortableRetryStrategy(this.actor);
        this.updateStateRetryStrategy = new RecoverableRetryStrategy(this.actor);
        this.shouldProcessNext = shouldProcessNext;
        int partitionId = this.logStream.getPartitionId();
        this.typedEvent = new TypedEventImpl(partitionId);
        this.responseWriter = context.getWriters().response();
        this.metrics = new StreamProcessorMetrics(partitionId);
        this.onProcessedListener = context.getOnProcessedListener();
        this.onSkippedListener = context.getOnSkippedListener();
    }

    private void skipRecord() {
        this.notifySkippedListener(this.currentEvent);
        this.actor.submit(this::readNextEvent);
        this.metrics.eventSkipped();
    }

    void readNextEvent() {
        if (this.onErrorRetries > 0) {
            this.onErrorHandlingLoop = false;
            this.onErrorRetries = 0;
        }
        if (this.onErrorHandling) {
            this.logStream.getCommitPositionAsync().onComplete((commitPosition, error) -> {
                if (error == null) {
                    if (commitPosition >= this.errorRecordPosition) {
                        LOG.info(LOG_ERROR_EVENT_COMMITTED);
                        this.onErrorHandling = false;
                        this.tryToReadNextEvent();
                    }
                } else {
                    LOG.error("Error on retrieving commit position", error);
                }
            });
        } else {
            this.tryToReadNextEvent();
        }
    }

    private void tryToReadNextEvent() {
        if (this.shouldProcessNext.getAsBoolean() && this.logStreamReader.hasNext() && this.currentProcessor == null) {
            this.currentEvent = (LoggedEvent)this.logStreamReader.next();
            if (this.eventFilter.applies(this.currentEvent)) {
                this.processEvent(this.currentEvent);
            } else {
                this.skipRecord();
            }
        }
    }

    private void processEvent(LoggedEvent event) {
        this.metadata.reset();
        event.readMetadata((BufferReader)this.metadata);
        this.currentProcessor = this.chooseNextProcessor(event);
        if (this.currentProcessor == null) {
            this.skipRecord();
            return;
        }
        this.processingStartTime = ActorClock.currentTimeMillis();
        try {
            UnifiedRecordValue value = this.recordValues.readRecordValue(event, this.metadata.getValueType());
            this.typedEvent.wrap(event, this.metadata, value);
            if (MigratedStreamProcessors.isMigrated(this.typedEvent) && this.typedEvent.getRecordType() != RecordType.COMMAND) {
                this.currentProcessor = null;
                this.skipRecord();
                return;
            }
            this.metrics.processingLatency(this.metadata.getRecordType(), event.getTimestamp(), this.processingStartTime);
            this.processInTransaction(this.typedEvent);
            this.metrics.eventProcessed();
            this.writeEvent();
        }
        catch (RecoverableException recoverableException) {
            LOG.error(ERROR_MESSAGE_PROCESSING_FAILED_RETRY_PROCESSING, (Object)event, (Object)recoverableException);
            this.actor.runDelayed(PROCESSING_RETRY_DELAY, () -> this.processEvent(this.currentEvent));
        }
        catch (Exception e) {
            LOG.error(ERROR_MESSAGE_PROCESSING_FAILED_SKIP_EVENT, (Object)event, (Object)e);
            this.onError(e, this::writeEvent);
        }
    }

    private TypedRecordProcessor<?> chooseNextProcessor(LoggedEvent event) {
        TypedRecordProcessor typedRecordProcessor = null;
        try {
            typedRecordProcessor = this.recordProcessorMap.get(this.metadata.getRecordType(), this.metadata.getValueType(), this.metadata.getIntent().value());
        }
        catch (Exception e) {
            LOG.error(ERROR_MESSAGE_ON_EVENT_FAILED_SKIP_EVENT, (Object)event, (Object)e);
        }
        return typedRecordProcessor;
    }

    private void processInTransaction(TypedEventImpl typedRecord) throws Exception {
        this.zeebeDbTransaction = this.transactionContext.getCurrentTransaction();
        this.zeebeDbTransaction.run(() -> {
            boolean isNotOnBlacklist;
            long position = typedRecord.getPosition();
            this.resetOutput(position);
            this.sideEffectProducer = this.responseWriter;
            boolean bl = isNotOnBlacklist = !this.zeebeState.getBlackListState().isOnBlacklist(typedRecord);
            if (isNotOnBlacklist) {
                this.currentProcessor.processRecord(position, typedRecord, this.responseWriter, this.logStreamWriter, this::setSideEffectProducer);
            }
            this.lastProcessedPositionState.markAsProcessed(position);
        });
    }

    private void resetOutput(long sourceRecordPosition) {
        this.responseWriter.reset();
        this.logStreamWriter.reset();
        this.logStreamWriter.configureSourceContext(sourceRecordPosition);
    }

    public void setSideEffectProducer(SideEffectProducer sideEffectProducer) {
        this.sideEffectProducer = sideEffectProducer;
    }

    private void onError(Throwable processingException, Runnable nextStep) {
        ++this.onErrorRetries;
        if (this.onErrorRetries > 1) {
            this.onErrorHandlingLoop = true;
        }
        ActorFuture retryFuture = this.updateStateRetryStrategy.runWithRetry(() -> {
            this.zeebeDbTransaction.rollback();
            return true;
        }, this.abortCondition);
        this.actor.runOnCompletion(retryFuture, (bool, throwable) -> {
            if (throwable != null) {
                LOG.error(ERROR_MESSAGE_ROLLBACK_ABORTED, (Object)this.currentEvent, throwable);
            }
            try {
                this.errorHandlingInTransaction(processingException);
                this.onErrorHandling = true;
                nextStep.run();
            }
            catch (Exception ex) {
                this.onError(ex, nextStep);
            }
        });
    }

    private void errorHandlingInTransaction(Throwable processingException) throws Exception {
        this.zeebeDbTransaction = this.transactionContext.getCurrentTransaction();
        this.zeebeDbTransaction.run(() -> {
            long position = this.typedEvent.getPosition();
            this.resetOutput(position);
            this.writeRejectionOnCommand(processingException);
            this.errorRecord.initErrorRecord(processingException, position);
            this.zeebeState.getBlackListState().tryToBlacklist(this.typedEvent, arg_0 -> ((ErrorRecord)this.errorRecord).setProcessInstanceKey(arg_0));
            this.logStreamWriter.appendFollowUpEvent(this.typedEvent.getKey(), (Intent)ErrorIntent.CREATED, (RecordValue)this.errorRecord);
        });
    }

    private void writeRejectionOnCommand(Throwable exception) {
        String errorMessage = String.format(PROCESSING_ERROR_MESSAGE, this.typedEvent, exception.getMessage());
        LOG.error(errorMessage, exception);
        if (this.typedEvent.getRecordType() == RecordType.COMMAND) {
            this.logStreamWriter.appendRejection(this.typedEvent, RejectionType.PROCESSING_ERROR, errorMessage);
            this.responseWriter.writeRejectionOnCommand(this.typedEvent, RejectionType.PROCESSING_ERROR, errorMessage);
        }
    }

    private void writeEvent() {
        ActorFuture retryFuture = this.writeRetryStrategy.runWithRetry(() -> {
            long position = this.logStreamWriter.flush();
            if (position > 0L) {
                this.writtenEventPosition = position;
            }
            return position >= 0L;
        }, this.abortCondition);
        this.actor.runOnCompletion(retryFuture, (bool, t) -> {
            if (t != null) {
                LOG.error(ERROR_MESSAGE_WRITE_EVENT_ABORTED, (Object)this.currentEvent, t);
                this.onError((Throwable)t, this::writeEvent);
            } else {
                this.updateState();
                this.metrics.eventWritten();
            }
        });
    }

    private void updateState() {
        ActorFuture retryFuture = this.updateStateRetryStrategy.runWithRetry(() -> {
            this.zeebeDbTransaction.commit();
            if (this.onErrorHandling) {
                this.errorRecordPosition = this.writtenEventPosition;
                this.logStream.getCommitPositionAsync().onComplete((commitPosition, error) -> {
                    if (error == null) {
                        LOG.info(LOG_ERROR_EVENT_WRITTEN, (Object)this.errorRecordPosition, commitPosition);
                    }
                });
            }
            this.lastSuccessfulProcessedEventPosition = this.currentEvent.getPosition();
            this.metrics.setLastProcessedPosition(this.lastSuccessfulProcessedEventPosition);
            this.lastWrittenEventPosition = this.writtenEventPosition;
            return true;
        }, this.abortCondition);
        this.actor.runOnCompletion(retryFuture, (bool, throwable) -> {
            if (throwable != null) {
                LOG.error(ERROR_MESSAGE_UPDATE_STATE_FAILED, (Object)this.currentEvent, throwable);
                this.onError((Throwable)throwable, this::updateState);
            } else {
                this.executeSideEffects();
            }
        });
    }

    private void executeSideEffects() {
        ActorFuture retryFuture = this.sideEffectsRetryStrategy.runWithRetry(this.sideEffectProducer::flush, this.abortCondition);
        this.actor.runOnCompletion(retryFuture, (bool, throwable) -> {
            if (throwable != null) {
                LOG.error(ERROR_MESSAGE_EXECUTE_SIDE_EFFECT_ABORTED, (Object)this.currentEvent, throwable);
            }
            this.notifyProcessedListener(this.typedEvent);
            this.metrics.processingDuration(this.metadata.getRecordType(), this.processingStartTime, ActorClock.currentTimeMillis());
            this.currentProcessor = null;
            this.actor.submit(this::readNextEvent);
        });
    }

    private void notifyProcessedListener(TypedRecord processedRecord) {
        try {
            this.onProcessedListener.accept(processedRecord);
        }
        catch (Exception e) {
            LOG.error(NOTIFY_PROCESSED_LISTENER_ERROR_MESSAGE, (Object)processedRecord, (Object)e);
        }
    }

    private void notifySkippedListener(LoggedEvent skippedRecord) {
        try {
            this.onSkippedListener.accept(skippedRecord);
        }
        catch (Exception e) {
            LOG.error(NOTIFY_SKIPPED_LISTENER_ERROR_MESSAGE, (Object)skippedRecord, (Object)e);
        }
    }

    public long getLastSuccessfulProcessedEventPosition() {
        return this.lastSuccessfulProcessedEventPosition;
    }

    public long getLastWrittenEventPosition() {
        return this.lastWrittenEventPosition;
    }

    public boolean isMakingProgress() {
        return !this.onErrorHandlingLoop;
    }

    public void startProcessing(long lastReprocessedPosition) {
        if (this.lastSuccessfulProcessedEventPosition == -1L) {
            this.lastSuccessfulProcessedEventPosition = lastReprocessedPosition;
        }
        this.actor.submit(this::readNextEvent);
    }
}

