/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.streamprocessor;

import io.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.zeebe.protocol.record.RecordType;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.intent.Intent;
import java.util.Iterator;

public final class RecordProcessorMap {
    private final TypedRecordProcessor[] elements;
    private final int valueTypeCardinality;
    private final int intentCardinality;
    private final ValueIterator valueIt = new ValueIterator();

    public <R extends Enum<R>, S extends Enum<S>> RecordProcessorMap() {
        int recordTypeCardinality = ((RecordType[])RecordType.class.getEnumConstants()).length;
        this.valueTypeCardinality = ((ValueType[])ValueType.class.getEnumConstants()).length;
        this.intentCardinality = Intent.maxCardinality();
        int cardinality = recordTypeCardinality * this.valueTypeCardinality * this.intentCardinality;
        this.elements = new TypedRecordProcessor[cardinality];
    }

    public TypedRecordProcessor get(RecordType key1, ValueType key2, int key3) {
        int index = this.mapToIndex(key1, key2, key3);
        if (index >= 0) {
            return this.elements[index];
        }
        return null;
    }

    public void put(RecordType key1, ValueType key2, int key3, TypedRecordProcessor value) {
        int index = this.mapToIndex(key1, key2, key3);
        if (index < 0) {
            throw new RuntimeException("Invalid intent value " + key3);
        }
        TypedRecordProcessor oldElement = this.elements[index];
        if (oldElement != null) {
            String exceptionMsg = String.format("Expected to have a single processor per intent, got for intent %s duplicate processor %s have already %s", Intent.fromProtocolValue((ValueType)key2, (short)((short)key3)), value.getClass().getName(), oldElement.getClass().getName());
            throw new IllegalStateException(exceptionMsg);
        }
        this.elements[index] = value;
    }

    private int mapToIndex(RecordType key1, ValueType key2, int key3) {
        if (key3 >= this.intentCardinality) {
            return -1;
        }
        return key1.ordinal() * this.valueTypeCardinality * this.intentCardinality + key2.ordinal() * this.intentCardinality + key3;
    }

    public Iterator<TypedRecordProcessor> values() {
        this.valueIt.init();
        return this.valueIt;
    }

    private class ValueIterator
    implements Iterator<TypedRecordProcessor> {
        private int next;

        private ValueIterator() {
        }

        private void scanToNext() {
            do {
                ++this.next;
            } while (this.next < RecordProcessorMap.this.elements.length && RecordProcessorMap.this.elements[this.next] == null);
        }

        public void init() {
            this.next = -1;
            this.scanToNext();
        }

        @Override
        public boolean hasNext() {
            return this.next < RecordProcessorMap.this.elements.length;
        }

        @Override
        public TypedRecordProcessor next() {
            TypedRecordProcessor element = RecordProcessorMap.this.elements[this.next];
            this.scanToNext();
            return element;
        }
    }
}

