/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.streamprocessor;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.zeebe.engine.processing.streamprocessor.CopiedRecords;
import io.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.zeebe.logstreams.log.LoggedEvent;
import io.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.zeebe.protocol.impl.record.RecordMetadata;
import io.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.zeebe.protocol.record.JsonSerializable;
import io.zeebe.protocol.record.Record;
import io.zeebe.protocol.record.RecordType;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.util.StringUtil;

public final class TypedEventImpl
implements TypedRecord {
    private final int partitionId;
    private LoggedEvent rawEvent;
    private RecordMetadata metadata;
    private UnifiedRecordValue value;

    public TypedEventImpl(int partitionId) {
        this.partitionId = partitionId;
    }

    public void wrap(LoggedEvent rawEvent, RecordMetadata metadata, UnifiedRecordValue value) {
        this.rawEvent = rawEvent;
        this.metadata = metadata;
        this.value = value;
    }

    public long getPosition() {
        return this.rawEvent.getPosition();
    }

    public long getSourceRecordPosition() {
        return this.rawEvent.getSourceEventPosition();
    }

    public long getTimestamp() {
        return this.rawEvent.getTimestamp();
    }

    public Intent getIntent() {
        return this.metadata.getIntent();
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public RecordType getRecordType() {
        return this.metadata.getRecordType();
    }

    public RejectionType getRejectionType() {
        return this.metadata.getRejectionType();
    }

    public String getRejectionReason() {
        return this.metadata.getRejectionReason();
    }

    public String getBrokerVersion() {
        return this.metadata.getBrokerVersion().toString();
    }

    public ValueType getValueType() {
        return this.metadata.getValueType();
    }

    @Override
    public long getKey() {
        return this.rawEvent.getKey();
    }

    public UnifiedRecordValue getValue() {
        return this.value;
    }

    @Override
    @JsonIgnore
    public int getRequestStreamId() {
        return this.metadata.getRequestStreamId();
    }

    @Override
    @JsonIgnore
    public long getRequestId() {
        return this.metadata.getRequestId();
    }

    @Override
    @JsonIgnore
    public long getLength() {
        return (long)this.metadata.getLength() + (long)this.value.getLength();
    }

    public String toJson() {
        return MsgPackConverter.convertJsonSerializableObjectToJson((JsonSerializable)this);
    }

    public Record clone() {
        return CopiedRecords.createCopiedRecord(this.getPartitionId(), this.rawEvent);
    }

    public String toString() {
        return "TypedEventImpl{metadata=" + this.metadata + ", value=" + StringUtil.limitString((String)this.value.toString(), (int)1024) + "}";
    }
}

