/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.timer;

import io.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.zeebe.engine.state.instance.TimerInstance;
import io.zeebe.engine.state.mutable.MutableTimerInstanceState;
import io.zeebe.protocol.impl.record.value.timer.TimerRecord;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.TimerIntent;

public final class CancelTimerProcessor
implements TypedRecordProcessor<TimerRecord> {
    public static final String NO_TIMER_FOUND_MESSAGE = "Expected to cancel timer with key '%d', but no such timer was found";
    private final MutableTimerInstanceState timerInstanceState;

    public CancelTimerProcessor(MutableTimerInstanceState timerInstanceState) {
        this.timerInstanceState = timerInstanceState;
    }

    @Override
    public void processRecord(TypedRecord<TimerRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter) {
        TimerRecord timer = record.getValue();
        TimerInstance timerInstance = this.timerInstanceState.get(timer.getElementInstanceKey(), record.getKey());
        if (timerInstance == null) {
            streamWriter.appendRejection(record, RejectionType.NOT_FOUND, String.format(NO_TIMER_FOUND_MESSAGE, record.getKey()));
        } else {
            streamWriter.appendFollowUpEvent(record.getKey(), (Intent)TimerIntent.CANCELED, (RecordValue)timer);
            this.timerInstanceState.remove(timerInstance);
        }
    }
}

