/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.timer;

import io.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.zeebe.engine.processing.streamprocessor.sideeffect.SideEffectProducer;
import io.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.zeebe.engine.processing.timer.DueDateTimerChecker;
import io.zeebe.engine.state.KeyGenerator;
import io.zeebe.engine.state.instance.TimerInstance;
import io.zeebe.engine.state.mutable.MutableTimerInstanceState;
import io.zeebe.engine.state.mutable.MutableZeebeState;
import io.zeebe.protocol.impl.record.value.timer.TimerRecord;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.TimerIntent;
import java.util.function.Consumer;

public final class CreateTimerProcessor
implements TypedRecordProcessor<TimerRecord> {
    private final DueDateTimerChecker timerChecker;
    private final MutableTimerInstanceState timerInstanceState;
    private final TimerInstance timerInstance = new TimerInstance();
    private final KeyGenerator keyGenerator;

    public CreateTimerProcessor(MutableZeebeState zeebeState, DueDateTimerChecker timerChecker) {
        this.timerChecker = timerChecker;
        this.timerInstanceState = zeebeState.getTimerState();
        this.keyGenerator = zeebeState.getKeyGenerator();
    }

    @Override
    public void processRecord(TypedRecord<TimerRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect) {
        TimerRecord timer = record.getValue();
        long timerKey = this.keyGenerator.nextKey();
        this.timerInstance.setElementInstanceKey(timer.getElementInstanceKey());
        this.timerInstance.setDueDate(timer.getDueDate());
        this.timerInstance.setKey(timerKey);
        this.timerInstance.setHandlerNodeId(timer.getTargetElementIdBuffer());
        this.timerInstance.setRepetitions(timer.getRepetitions());
        this.timerInstance.setProcessDefinitionKey(timer.getProcessDefinitionKey());
        this.timerInstance.setProcessInstanceKey(timer.getProcessInstanceKey());
        sideEffect.accept(this::scheduleTimer);
        streamWriter.appendFollowUpEvent(timerKey, (Intent)TimerIntent.CREATED, (RecordValue)timer);
        this.timerInstanceState.put(this.timerInstance);
    }

    private boolean scheduleTimer() {
        this.timerChecker.scheduleTimer(this.timerInstance);
        return true;
    }
}

