/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.timer;

import io.zeebe.engine.processing.streamprocessor.ReadonlyProcessingContext;
import io.zeebe.engine.processing.streamprocessor.StreamProcessorLifecycleAware;
import io.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.zeebe.engine.state.immutable.TimerInstanceState;
import io.zeebe.engine.state.instance.TimerInstance;
import io.zeebe.protocol.impl.record.value.timer.TimerRecord;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.TimerIntent;
import io.zeebe.util.sched.ActorControl;
import io.zeebe.util.sched.ScheduledTimer;
import io.zeebe.util.sched.clock.ActorClock;
import java.time.Duration;

public class DueDateTimerChecker
implements StreamProcessorLifecycleAware {
    private static final long TIMER_RESOLUTION = Duration.ofMillis(100L).toMillis();
    private final TimerRecord timerRecord = new TimerRecord();
    private final TimerInstanceState timerInstanceState;
    private ActorControl actor;
    private TypedStreamWriter streamWriter;
    private ScheduledTimer scheduledTimer;
    private long nextDueDate = -1L;

    public DueDateTimerChecker(TimerInstanceState timerInstanceState) {
        this.timerInstanceState = timerInstanceState;
    }

    public void scheduleTimer(TimerInstance timer) {
        Duration duration = Duration.ofMillis(timer.getDueDate() - ActorClock.currentTimeMillis());
        if (this.scheduledTimer == null) {
            this.scheduledTimer = this.actor.runDelayed(duration, this::triggerTimers);
            this.nextDueDate = timer.getDueDate();
        } else if (this.nextDueDate - timer.getDueDate() > TIMER_RESOLUTION) {
            this.scheduledTimer.cancel();
            this.scheduledTimer = this.actor.runDelayed(duration, this::triggerTimers);
            this.nextDueDate = timer.getDueDate();
        }
    }

    private void triggerTimers() {
        this.nextDueDate = this.timerInstanceState.findTimersWithDueDateBefore(ActorClock.currentTimeMillis(), this::triggerTimer);
        if (this.nextDueDate > 0L) {
            Duration duration = Duration.ofMillis(this.nextDueDate - ActorClock.currentTimeMillis());
            this.scheduledTimer = this.actor.runDelayed(duration, this::triggerTimers);
        } else {
            this.scheduledTimer = null;
        }
    }

    private boolean triggerTimer(TimerInstance timer) {
        this.timerRecord.reset();
        this.timerRecord.setElementInstanceKey(timer.getElementInstanceKey()).setProcessInstanceKey(timer.getProcessInstanceKey()).setDueDate(timer.getDueDate()).setTargetElementId(timer.getHandlerNodeId()).setRepetitions(timer.getRepetitions()).setProcessDefinitionKey(timer.getProcessDefinitionKey());
        this.streamWriter.reset();
        this.streamWriter.appendFollowUpCommand(timer.getKey(), (Intent)TimerIntent.TRIGGER, (RecordValue)this.timerRecord);
        return this.streamWriter.flush() > 0L;
    }

    @Override
    public void onRecovered(ReadonlyProcessingContext processingContext) {
        this.actor = processingContext.getActor();
        this.streamWriter = processingContext.getLogStreamWriter();
        this.triggerTimers();
    }

    @Override
    public void onPaused() {
        if (this.scheduledTimer != null) {
            this.scheduledTimer.cancel();
            this.scheduledTimer = null;
        }
    }

    @Override
    public void onResumed() {
        if (this.scheduledTimer == null) {
            this.triggerTimers();
        }
    }
}

