/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.timer;

import io.zeebe.engine.processing.common.CatchEventBehavior;
import io.zeebe.engine.processing.common.EventHandle;
import io.zeebe.engine.processing.common.ExpressionProcessor;
import io.zeebe.engine.processing.common.Failure;
import io.zeebe.engine.processing.deployment.model.element.ExecutableCatchEvent;
import io.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.zeebe.engine.state.immutable.ElementInstanceState;
import io.zeebe.engine.state.immutable.ProcessState;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.engine.state.instance.TimerInstance;
import io.zeebe.engine.state.mutable.MutableTimerInstanceState;
import io.zeebe.engine.state.mutable.MutableZeebeState;
import io.zeebe.model.bpmn.util.time.Interval;
import io.zeebe.model.bpmn.util.time.RepeatingInterval;
import io.zeebe.model.bpmn.util.time.Timer;
import io.zeebe.protocol.impl.record.value.timer.TimerRecord;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.TimerIntent;
import io.zeebe.util.Either;
import io.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class TriggerTimerProcessor
implements TypedRecordProcessor<TimerRecord> {
    private static final String NO_TIMER_FOUND_MESSAGE = "Expected to trigger timer with key '%d', but no such timer was found";
    private static final String NO_ACTIVE_TIMER_MESSAGE = "Expected to trigger a timer with key '%d', but the timer is not active anymore";
    private static final DirectBuffer NO_VARIABLES = new UnsafeBuffer();
    private final CatchEventBehavior catchEventBehavior;
    private final ProcessState processState;
    private final ElementInstanceState elementInstanceState;
    private final MutableTimerInstanceState timerInstanceState;
    private final EventHandle eventHandle;
    private final ExpressionProcessor expressionProcessor;

    public TriggerTimerProcessor(MutableZeebeState zeebeState, CatchEventBehavior catchEventBehavior, ExpressionProcessor expressionProcessor) {
        this.catchEventBehavior = catchEventBehavior;
        this.expressionProcessor = expressionProcessor;
        this.processState = zeebeState.getProcessState();
        this.elementInstanceState = zeebeState.getElementInstanceState();
        this.timerInstanceState = zeebeState.getTimerState();
        this.eventHandle = new EventHandle(zeebeState.getKeyGenerator(), zeebeState.getEventScopeInstanceState());
    }

    @Override
    public void processRecord(TypedRecord<TimerRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter) {
        TimerRecord timer = record.getValue();
        long elementInstanceKey = timer.getElementInstanceKey();
        TimerInstance timerInstance = this.timerInstanceState.get(elementInstanceKey, record.getKey());
        if (timerInstance == null) {
            streamWriter.appendRejection(record, RejectionType.NOT_FOUND, String.format(NO_TIMER_FOUND_MESSAGE, record.getKey()));
            return;
        }
        this.timerInstanceState.remove(timerInstance);
        this.processTimerTrigger(record, streamWriter, timer, elementInstanceKey);
    }

    private void processTimerTrigger(TypedRecord<TimerRecord> record, TypedStreamWriter streamWriter, TimerRecord timer, long elementInstanceKey) {
        ExecutableCatchEvent catchEvent;
        long processDefinitionKey = timer.getProcessDefinitionKey();
        boolean isTriggered = this.triggerEvent(streamWriter, timer, elementInstanceKey, processDefinitionKey, catchEvent = this.processState.getFlowElement(processDefinitionKey, timer.getTargetElementIdBuffer(), ExecutableCatchEvent.class));
        if (isTriggered) {
            streamWriter.appendFollowUpEvent(record.getKey(), (Intent)TimerIntent.TRIGGERED, (RecordValue)timer);
            if (this.shouldReschedule(timer)) {
                this.rescheduleTimer(timer, streamWriter, catchEvent);
            }
        } else {
            streamWriter.appendRejection(record, RejectionType.INVALID_STATE, String.format(NO_ACTIVE_TIMER_MESSAGE, record.getKey()));
        }
    }

    private boolean triggerEvent(TypedStreamWriter streamWriter, TimerRecord timer, long elementInstanceKey, long processDefinitionKey, ExecutableCatchEvent catchEvent) {
        if (elementInstanceKey > 0L) {
            ElementInstance elementInstance = this.elementInstanceState.getInstance(elementInstanceKey);
            if (elementInstance != null && elementInstance.isActive()) {
                return this.eventHandle.triggerEvent(streamWriter, elementInstance, catchEvent, NO_VARIABLES);
            }
            return false;
        }
        long processInstanceKey = this.eventHandle.triggerStartEvent(streamWriter, processDefinitionKey, timer.getTargetElementIdBuffer(), NO_VARIABLES);
        return processInstanceKey > 0L;
    }

    private boolean shouldReschedule(TimerRecord timer) {
        return timer.getRepetitions() == -1 || timer.getRepetitions() > 1;
    }

    private void rescheduleTimer(TimerRecord record, TypedStreamWriter writer, ExecutableCatchEvent event) {
        Either<Failure, Timer> timer = event.getTimerFactory().apply(this.expressionProcessor, record.getElementInstanceKey());
        if (timer.isLeft()) {
            String message = String.format("Expected to reschedule repeating timer for element with id '%s', but an error occurred: %s", BufferUtil.bufferAsString((DirectBuffer)event.getId()), ((Failure)timer.getLeft()).getMessage());
            throw new IllegalStateException(message);
        }
        int repetitions = record.getRepetitions();
        if (repetitions != -1) {
            --repetitions;
        }
        Interval interval = (Interval)timer.map(Timer::getInterval).get();
        RepeatingInterval repeatingInterval = new RepeatingInterval(repetitions, interval);
        this.catchEventBehavior.subscribeToTimerEvent(record.getElementInstanceKey(), record.getProcessInstanceKey(), record.getProcessDefinitionKey(), event.getId(), (Timer)repeatingInterval, writer);
    }
}

