/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.variable;

import io.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.zeebe.engine.processing.variable.VariableBehavior;
import io.zeebe.engine.state.KeyGenerator;
import io.zeebe.engine.state.immutable.ElementInstanceState;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.msgpack.spec.MsgpackReaderException;
import io.zeebe.protocol.impl.record.value.variable.VariableDocumentRecord;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.VariableDocumentIntent;
import io.zeebe.protocol.record.value.VariableDocumentUpdateSemantic;

public final class UpdateVariableDocumentProcessor
implements TypedRecordProcessor<VariableDocumentRecord> {
    private final ElementInstanceState elementInstanceState;
    private final KeyGenerator keyGenerator;
    private final VariableBehavior variableBehavior;
    private final StateWriter stateWriter;

    public UpdateVariableDocumentProcessor(ElementInstanceState elementInstanceState, KeyGenerator keyGenerator, VariableBehavior variableBehavior, StateWriter stateWriter) {
        this.elementInstanceState = elementInstanceState;
        this.keyGenerator = keyGenerator;
        this.variableBehavior = variableBehavior;
        this.stateWriter = stateWriter;
    }

    @Override
    public void processRecord(TypedRecord<VariableDocumentRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter) {
        VariableDocumentRecord value = record.getValue();
        ElementInstance scope = this.elementInstanceState.getInstance(value.getScopeKey());
        if (scope == null || scope.isTerminating() || scope.isInFinalState()) {
            String reason = String.format("Expected to update variables for element with key '%d', but no such element was found", value.getScopeKey());
            streamWriter.appendRejection(record, RejectionType.NOT_FOUND, reason);
            responseWriter.writeRejectionOnCommand(record, RejectionType.NOT_FOUND, reason);
            return;
        }
        long processDefinitionKey = scope.getValue().getProcessDefinitionKey();
        long processInstanceKey = scope.getValue().getProcessInstanceKey();
        try {
            if (value.getUpdateSemantics() == VariableDocumentUpdateSemantic.LOCAL) {
                this.variableBehavior.mergeLocalDocument(scope.getKey(), processDefinitionKey, processInstanceKey, value.getVariablesBuffer());
            } else {
                this.variableBehavior.mergeDocument(scope.getKey(), processDefinitionKey, processInstanceKey, value.getVariablesBuffer());
            }
        }
        catch (MsgpackReaderException e) {
            String reason = String.format("Expected document to be valid msgpack, but it could not be read: '%s'", e.getMessage());
            streamWriter.appendRejection(record, RejectionType.INVALID_ARGUMENT, reason);
            responseWriter.writeRejectionOnCommand(record, RejectionType.INVALID_ARGUMENT, reason);
            return;
        }
        long key = this.keyGenerator.nextKey();
        this.stateWriter.appendFollowUpEvent(key, (Intent)VariableDocumentIntent.UPDATED, (RecordValue)value);
        responseWriter.writeEventOnCommand(key, (Intent)VariableDocumentIntent.UPDATED, (UnpackedObject)value, record);
    }
}

