/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state;

import io.zeebe.db.ColumnFamily;
import io.zeebe.db.DbKey;
import io.zeebe.db.DbValue;
import io.zeebe.db.TransactionContext;
import io.zeebe.db.ZeebeDb;
import io.zeebe.db.impl.DbString;
import io.zeebe.engine.state.NextValue;
import io.zeebe.engine.state.ZbColumnFamilies;
import org.agrona.DirectBuffer;

public final class NextValueManager {
    private final long initialValue;
    private final ColumnFamily<DbString, NextValue> nextValueColumnFamily;
    private final DbString nextValueKey;
    private final NextValue nextValue = new NextValue();

    public NextValueManager(long initialValue, ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext, ZbColumnFamilies columnFamily) {
        this.initialValue = initialValue;
        this.nextValueKey = new DbString();
        this.nextValueColumnFamily = zeebeDb.createColumnFamily((Enum)columnFamily, transactionContext, (DbKey)this.nextValueKey, (DbValue)this.nextValue);
    }

    public long getNextValue(String key) {
        long previousKey = this.getCurrentValue(key);
        long nextKey = previousKey + 1L;
        this.nextValue.set(nextKey);
        this.nextValueColumnFamily.put((DbKey)this.nextValueKey, (DbValue)this.nextValue);
        return nextKey;
    }

    public void setValue(String key, long value) {
        this.nextValueKey.wrapString(key);
        this.nextValue.set(value);
        this.nextValueColumnFamily.put((DbKey)this.nextValueKey, (DbValue)this.nextValue);
    }

    public long getCurrentValue(String key) {
        this.nextValueKey.wrapString(key);
        return this.getCurrentValue();
    }

    public long getCurrentValue(DirectBuffer key) {
        this.nextValueKey.wrapBuffer(key);
        return this.getCurrentValue();
    }

    private long getCurrentValue() {
        NextValue readValue = (NextValue)this.nextValueColumnFamily.get((DbKey)this.nextValueKey);
        long currentValue = this.initialValue;
        if (readValue != null) {
            currentValue = readValue.get();
        }
        return currentValue;
    }
}

