/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state;

import io.zeebe.db.DbKey;
import io.zeebe.db.DbValue;
import io.zeebe.db.TransactionContext;
import io.zeebe.db.ZeebeDb;
import io.zeebe.engine.state.KeyGenerator;
import io.zeebe.engine.state.KeyGeneratorControls;
import io.zeebe.engine.state.ZbColumnFamilies;
import io.zeebe.engine.state.deployment.DbDeploymentState;
import io.zeebe.engine.state.deployment.DbProcessState;
import io.zeebe.engine.state.instance.DbElementInstanceState;
import io.zeebe.engine.state.instance.DbEventScopeInstanceState;
import io.zeebe.engine.state.instance.DbIncidentState;
import io.zeebe.engine.state.instance.DbJobState;
import io.zeebe.engine.state.instance.DbTimerInstanceState;
import io.zeebe.engine.state.message.DbMessageStartEventSubscriptionState;
import io.zeebe.engine.state.message.DbMessageState;
import io.zeebe.engine.state.message.DbMessageSubscriptionState;
import io.zeebe.engine.state.message.DbProcessInstanceSubscriptionState;
import io.zeebe.engine.state.mutable.MutableBlackListState;
import io.zeebe.engine.state.mutable.MutableDeploymentState;
import io.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import io.zeebe.engine.state.mutable.MutableIncidentState;
import io.zeebe.engine.state.mutable.MutableJobState;
import io.zeebe.engine.state.mutable.MutableLastProcessedPositionState;
import io.zeebe.engine.state.mutable.MutableMessageStartEventSubscriptionState;
import io.zeebe.engine.state.mutable.MutableMessageState;
import io.zeebe.engine.state.mutable.MutableMessageSubscriptionState;
import io.zeebe.engine.state.mutable.MutableProcessInstanceSubscriptionState;
import io.zeebe.engine.state.mutable.MutableProcessState;
import io.zeebe.engine.state.mutable.MutableTimerInstanceState;
import io.zeebe.engine.state.mutable.MutableVariableState;
import io.zeebe.engine.state.mutable.MutableZeebeState;
import io.zeebe.engine.state.processing.DbBlackListState;
import io.zeebe.engine.state.processing.DbKeyGenerator;
import io.zeebe.engine.state.processing.DbLastProcessedPositionState;
import io.zeebe.engine.state.variable.DbVariableState;
import java.util.function.BiConsumer;

public class ZeebeDbState
implements MutableZeebeState {
    private final ZeebeDb<ZbColumnFamilies> zeebeDb;
    private final DbKeyGenerator keyGenerator;
    private final MutableProcessState processState;
    private final MutableTimerInstanceState timerInstanceState;
    private final MutableElementInstanceState elementInstanceState;
    private final MutableEventScopeInstanceState eventScopeInstanceState;
    private final MutableVariableState variableState;
    private final MutableDeploymentState deploymentState;
    private final MutableJobState jobState;
    private final MutableMessageState messageState;
    private final MutableMessageSubscriptionState messageSubscriptionState;
    private final MutableMessageStartEventSubscriptionState messageStartEventSubscriptionState;
    private final MutableProcessInstanceSubscriptionState processInstanceSubscriptionState;
    private final MutableIncidentState incidentState;
    private final MutableBlackListState blackListState;
    private final MutableLastProcessedPositionState lastProcessedPositionState;
    private final int partitionId;

    public ZeebeDbState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this(1, zeebeDb, transactionContext);
    }

    public ZeebeDbState(int partitionId, ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.partitionId = partitionId;
        this.zeebeDb = zeebeDb;
        this.keyGenerator = new DbKeyGenerator(partitionId, zeebeDb, transactionContext);
        this.variableState = new DbVariableState(zeebeDb, transactionContext);
        this.processState = new DbProcessState(zeebeDb, transactionContext);
        this.timerInstanceState = new DbTimerInstanceState(zeebeDb, transactionContext);
        this.elementInstanceState = new DbElementInstanceState(zeebeDb, transactionContext, this.variableState);
        this.eventScopeInstanceState = new DbEventScopeInstanceState(zeebeDb, transactionContext);
        this.deploymentState = new DbDeploymentState(zeebeDb, transactionContext);
        this.jobState = new DbJobState(zeebeDb, transactionContext, partitionId);
        this.messageState = new DbMessageState(zeebeDb, transactionContext);
        this.messageSubscriptionState = new DbMessageSubscriptionState(zeebeDb, transactionContext);
        this.messageStartEventSubscriptionState = new DbMessageStartEventSubscriptionState(zeebeDb, transactionContext);
        this.processInstanceSubscriptionState = new DbProcessInstanceSubscriptionState(zeebeDb, transactionContext);
        this.incidentState = new DbIncidentState(zeebeDb, transactionContext, partitionId);
        this.blackListState = new DbBlackListState(zeebeDb, transactionContext);
        this.lastProcessedPositionState = new DbLastProcessedPositionState(zeebeDb, transactionContext);
    }

    @Override
    public MutableDeploymentState getDeploymentState() {
        return this.deploymentState;
    }

    @Override
    public MutableProcessState getProcessState() {
        return this.processState;
    }

    @Override
    public MutableJobState getJobState() {
        return this.jobState;
    }

    @Override
    public MutableMessageState getMessageState() {
        return this.messageState;
    }

    @Override
    public MutableMessageSubscriptionState getMessageSubscriptionState() {
        return this.messageSubscriptionState;
    }

    @Override
    public MutableMessageStartEventSubscriptionState getMessageStartEventSubscriptionState() {
        return this.messageStartEventSubscriptionState;
    }

    @Override
    public MutableProcessInstanceSubscriptionState getProcessInstanceSubscriptionState() {
        return this.processInstanceSubscriptionState;
    }

    @Override
    public MutableIncidentState getIncidentState() {
        return this.incidentState;
    }

    @Override
    public MutableBlackListState getBlackListState() {
        return this.blackListState;
    }

    @Override
    public MutableVariableState getVariableState() {
        return this.variableState;
    }

    @Override
    public MutableTimerInstanceState getTimerState() {
        return this.timerInstanceState;
    }

    @Override
    public MutableElementInstanceState getElementInstanceState() {
        return this.elementInstanceState;
    }

    @Override
    public MutableEventScopeInstanceState getEventScopeInstanceState() {
        return this.eventScopeInstanceState;
    }

    @Override
    public KeyGenerator getKeyGenerator() {
        return this.keyGenerator;
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public boolean isEmpty(ZbColumnFamilies column) {
        TransactionContext newContext = this.zeebeDb.createContext();
        return this.zeebeDb.isEmpty((Enum)column, newContext);
    }

    public <KeyType extends DbKey, ValueType extends DbValue> void forEach(ZbColumnFamilies columnFamily, KeyType keyInstance, ValueType valueInstance, BiConsumer<KeyType, ValueType> visitor) {
        TransactionContext newContext = this.zeebeDb.createContext();
        this.zeebeDb.createColumnFamily((Enum)columnFamily, newContext, keyInstance, valueInstance).forEach(visitor);
    }

    public KeyGeneratorControls getKeyGeneratorControls() {
        return this.keyGenerator;
    }

    public MutableLastProcessedPositionState getLastProcessedPositionState() {
        return this.lastProcessedPositionState;
    }
}

