/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.appliers;

import io.zeebe.engine.Loggers;
import io.zeebe.engine.state.EventApplier;
import io.zeebe.engine.state.TypedEventApplier;
import io.zeebe.engine.state.appliers.DeploymentCreatedApplier;
import io.zeebe.engine.state.appliers.DeploymentDistributedApplier;
import io.zeebe.engine.state.appliers.DeploymentDistributionApplier;
import io.zeebe.engine.state.appliers.DeploymentDistributionCompletedApplier;
import io.zeebe.engine.state.appliers.DeploymentFullyDistributedApplier;
import io.zeebe.engine.state.appliers.IncidentCreatedApplier;
import io.zeebe.engine.state.appliers.IncidentResolvedApplier;
import io.zeebe.engine.state.appliers.JobBatchActivatedApplier;
import io.zeebe.engine.state.appliers.JobCanceledApplier;
import io.zeebe.engine.state.appliers.JobCompletedApplier;
import io.zeebe.engine.state.appliers.JobCreatedApplier;
import io.zeebe.engine.state.appliers.JobErrorThrownApplier;
import io.zeebe.engine.state.appliers.JobFailedApplier;
import io.zeebe.engine.state.appliers.JobRetriesUpdatedApplier;
import io.zeebe.engine.state.appliers.JobTimedOutApplier;
import io.zeebe.engine.state.appliers.MessageExpiredApplier;
import io.zeebe.engine.state.appliers.MessagePublishedApplier;
import io.zeebe.engine.state.appliers.MessageStartEventSubscriptionCorrelatedApplier;
import io.zeebe.engine.state.appliers.MessageStartEventSubscriptionCreatedApplier;
import io.zeebe.engine.state.appliers.MessageStartEventSubscriptionDeletedApplier;
import io.zeebe.engine.state.appliers.MessageSubscriptionCorrelatedApplier;
import io.zeebe.engine.state.appliers.MessageSubscriptionCorrelatingApplier;
import io.zeebe.engine.state.appliers.MessageSubscriptionCreatedApplier;
import io.zeebe.engine.state.appliers.MessageSubscriptionDeletedApplier;
import io.zeebe.engine.state.appliers.MessageSubscriptionRejectedApplier;
import io.zeebe.engine.state.appliers.ProcessCreatedApplier;
import io.zeebe.engine.state.appliers.ProcessInstanceElementActivatedApplier;
import io.zeebe.engine.state.appliers.ProcessInstanceElementActivatingApplier;
import io.zeebe.engine.state.appliers.ProcessInstanceElementCompletedApplier;
import io.zeebe.engine.state.appliers.ProcessInstanceElementCompletingApplier;
import io.zeebe.engine.state.appliers.ProcessInstanceElementTerminatedApplier;
import io.zeebe.engine.state.appliers.ProcessInstanceElementTerminatingApplier;
import io.zeebe.engine.state.appliers.ProcessInstanceSequenceFlowTakenApplier;
import io.zeebe.engine.state.appliers.ProcessInstanceSubscriptionCreatedApplier;
import io.zeebe.engine.state.appliers.ProcessInstanceSubscriptionCreatingApplier;
import io.zeebe.engine.state.appliers.ProcessInstanceSubscriptionDeletedApplier;
import io.zeebe.engine.state.appliers.VariableApplier;
import io.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import io.zeebe.engine.state.mutable.MutableProcessState;
import io.zeebe.engine.state.mutable.MutableVariableState;
import io.zeebe.engine.state.mutable.MutableZeebeState;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.intent.DeploymentDistributionIntent;
import io.zeebe.protocol.record.intent.DeploymentIntent;
import io.zeebe.protocol.record.intent.IncidentIntent;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.JobBatchIntent;
import io.zeebe.protocol.record.intent.JobIntent;
import io.zeebe.protocol.record.intent.MessageIntent;
import io.zeebe.protocol.record.intent.MessageStartEventSubscriptionIntent;
import io.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.zeebe.protocol.record.intent.ProcessInstanceSubscriptionIntent;
import io.zeebe.protocol.record.intent.ProcessIntent;
import io.zeebe.protocol.record.intent.VariableIntent;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;

public final class EventAppliers
implements EventApplier {
    private static final Logger LOG = Loggers.STREAM_PROCESSING;
    private static final Function<Intent, TypedEventApplier<?, ?>> UNIMPLEMENTED_EVENT_APPLIER = intent -> (key, value) -> LOG.trace("No state changed: tried to use unimplemented event applier {}.{}", (Object)intent.getClass().getSimpleName(), intent);
    private final Map<Intent, TypedEventApplier> mapping = new HashMap<Intent, TypedEventApplier>();

    public EventAppliers(MutableZeebeState state) {
        this.registerProcessInstanceEventAppliers(state);
        this.register(ProcessIntent.CREATED, new ProcessCreatedApplier(state));
        this.registerDeploymentAppliers(state);
        this.registerMessageAppliers(state);
        this.registerMessageSubscriptionAppliers(state);
        this.registerMessageStartEventSubscriptionAppliers(state);
        this.registerJobIntentEventAppliers(state);
        this.registerVariableEventAppliers(state);
        this.register(JobBatchIntent.ACTIVATED, new JobBatchActivatedApplier(state));
        this.registerIncidentEventAppliers(state);
        this.registerProcessInstanceSubscriptionEventAppliers(state);
    }

    private void registerDeploymentAppliers(MutableZeebeState state) {
        this.register(DeploymentDistributionIntent.DISTRIBUTING, new DeploymentDistributionApplier(state));
        this.register(DeploymentDistributionIntent.COMPLETED, new DeploymentDistributionCompletedApplier(state.getDeploymentState()));
        this.register(DeploymentIntent.CREATED, new DeploymentCreatedApplier(state.getDeploymentState()));
        this.register(DeploymentIntent.DISTRIBUTED, new DeploymentDistributedApplier(state.getProcessState()));
        this.register(DeploymentIntent.FULLY_DISTRIBUTED, new DeploymentFullyDistributedApplier(state.getDeploymentState()));
    }

    private void registerVariableEventAppliers(MutableZeebeState state) {
        VariableApplier variableApplier = new VariableApplier(state.getVariableState());
        this.register(VariableIntent.CREATED, variableApplier);
        this.register(VariableIntent.UPDATED, variableApplier);
    }

    private void registerProcessInstanceEventAppliers(MutableZeebeState state) {
        MutableElementInstanceState elementInstanceState = state.getElementInstanceState();
        MutableEventScopeInstanceState eventScopeInstanceState = state.getEventScopeInstanceState();
        MutableProcessState processState = state.getProcessState();
        MutableVariableState variableState = state.getVariableState();
        this.register(ProcessInstanceIntent.ELEMENT_ACTIVATING, new ProcessInstanceElementActivatingApplier(elementInstanceState, processState, variableState));
        this.register(ProcessInstanceIntent.ELEMENT_ACTIVATED, new ProcessInstanceElementActivatedApplier(elementInstanceState, processState, eventScopeInstanceState));
        this.register(ProcessInstanceIntent.ELEMENT_COMPLETING, new ProcessInstanceElementCompletingApplier(elementInstanceState));
        this.register(ProcessInstanceIntent.ELEMENT_COMPLETED, new ProcessInstanceElementCompletedApplier(elementInstanceState, eventScopeInstanceState));
        this.register(ProcessInstanceIntent.ELEMENT_TERMINATING, new ProcessInstanceElementTerminatingApplier(elementInstanceState));
        this.register(ProcessInstanceIntent.ELEMENT_TERMINATED, new ProcessInstanceElementTerminatedApplier(elementInstanceState, eventScopeInstanceState));
        this.register(ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN, new ProcessInstanceSequenceFlowTakenApplier(elementInstanceState));
    }

    private void registerJobIntentEventAppliers(MutableZeebeState state) {
        this.register(JobIntent.CANCELED, new JobCanceledApplier(state));
        this.register(JobIntent.COMPLETED, new JobCompletedApplier(state));
        this.register(JobIntent.CREATED, new JobCreatedApplier(state));
        this.register(JobIntent.ERROR_THROWN, new JobErrorThrownApplier(state));
        this.register(JobIntent.FAILED, new JobFailedApplier(state));
        this.register(JobIntent.RETRIES_UPDATED, new JobRetriesUpdatedApplier(state));
        this.register(JobIntent.TIMED_OUT, new JobTimedOutApplier(state));
    }

    private void registerMessageAppliers(MutableZeebeState state) {
        this.register(MessageIntent.PUBLISHED, new MessagePublishedApplier(state.getMessageState()));
        this.register(MessageIntent.EXPIRED, new MessageExpiredApplier(state.getMessageState()));
    }

    private void registerMessageSubscriptionAppliers(MutableZeebeState state) {
        this.register(MessageSubscriptionIntent.CREATED, new MessageSubscriptionCreatedApplier(state.getMessageSubscriptionState()));
        this.register(MessageSubscriptionIntent.CORRELATING, new MessageSubscriptionCorrelatingApplier(state.getMessageSubscriptionState(), state.getMessageState()));
        this.register(MessageSubscriptionIntent.CORRELATED, new MessageSubscriptionCorrelatedApplier(state.getMessageSubscriptionState()));
        this.register(MessageSubscriptionIntent.REJECTED, new MessageSubscriptionRejectedApplier(state.getMessageState()));
        this.register(MessageSubscriptionIntent.DELETED, new MessageSubscriptionDeletedApplier(state.getMessageSubscriptionState()));
    }

    private void registerMessageStartEventSubscriptionAppliers(MutableZeebeState state) {
        this.register(MessageStartEventSubscriptionIntent.CREATED, new MessageStartEventSubscriptionCreatedApplier(state.getMessageStartEventSubscriptionState(), state.getEventScopeInstanceState()));
        this.register(MessageStartEventSubscriptionIntent.CORRELATED, new MessageStartEventSubscriptionCorrelatedApplier(state.getMessageState(), state.getEventScopeInstanceState()));
        this.register(MessageStartEventSubscriptionIntent.DELETED, new MessageStartEventSubscriptionDeletedApplier(state.getMessageStartEventSubscriptionState(), state.getEventScopeInstanceState()));
    }

    private void registerIncidentEventAppliers(MutableZeebeState state) {
        this.register(IncidentIntent.CREATED, new IncidentCreatedApplier(state.getIncidentState(), state.getJobState()));
        this.register(IncidentIntent.RESOLVED, new IncidentResolvedApplier(state.getIncidentState(), state.getJobState()));
    }

    private void registerProcessInstanceSubscriptionEventAppliers(MutableZeebeState state) {
        this.register(ProcessInstanceSubscriptionIntent.CREATING, new ProcessInstanceSubscriptionCreatingApplier(state.getProcessInstanceSubscriptionState()));
        this.register(ProcessInstanceSubscriptionIntent.CREATED, new ProcessInstanceSubscriptionCreatedApplier(state.getProcessInstanceSubscriptionState()));
        this.register(ProcessInstanceSubscriptionIntent.DELETED, new ProcessInstanceSubscriptionDeletedApplier(state.getProcessInstanceSubscriptionState()));
    }

    private <I extends Intent> void register(I intent, TypedEventApplier<I, ?> applier) {
        this.mapping.put(intent, applier);
    }

    @Override
    public void applyState(long key, Intent intent, RecordValue value) {
        TypedEventApplier<?, ?> eventApplier = this.mapping.getOrDefault(intent, UNIMPLEMENTED_EVENT_APPLIER.apply(intent));
        eventApplier.applyState(key, value);
    }
}

