/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.appliers;

import io.zeebe.engine.state.TypedEventApplier;
import io.zeebe.engine.state.mutable.MutableIncidentState;
import io.zeebe.engine.state.mutable.MutableJobState;
import io.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.zeebe.protocol.impl.record.value.job.JobRecord;
import io.zeebe.protocol.record.intent.IncidentIntent;
import io.zeebe.protocol.record.value.ErrorType;

final class IncidentCreatedApplier
implements TypedEventApplier<IncidentIntent, IncidentRecord> {
    private final MutableIncidentState incidentState;
    private final MutableJobState jobState;

    public IncidentCreatedApplier(MutableIncidentState incidentState, MutableJobState jobState) {
        this.incidentState = incidentState;
        this.jobState = jobState;
    }

    @Override
    public void applyState(long incidentKey, IncidentRecord value) {
        this.incidentState.createIncident(incidentKey, value);
        if (ErrorType.MESSAGE_SIZE_EXCEEDED == value.getErrorType()) {
            long jobKey = value.getJobKey();
            JobRecord jobRecord = this.jobState.getJob(jobKey);
            this.jobState.disable(jobKey, jobRecord);
        }
    }
}

