/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.appliers;

import io.zeebe.engine.state.TypedEventApplier;
import io.zeebe.engine.state.immutable.JobState;
import io.zeebe.engine.state.mutable.MutableIncidentState;
import io.zeebe.engine.state.mutable.MutableJobState;
import io.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.zeebe.protocol.impl.record.value.job.JobRecord;
import io.zeebe.protocol.record.intent.IncidentIntent;

final class IncidentResolvedApplier
implements TypedEventApplier<IncidentIntent, IncidentRecord> {
    private final MutableIncidentState incidentState;
    private final MutableJobState jobState;

    public IncidentResolvedApplier(MutableIncidentState incidentState, MutableJobState jobState) {
        this.incidentState = incidentState;
        this.jobState = jobState;
    }

    @Override
    public void applyState(long incidentKey, IncidentRecord value) {
        JobState.State stateOfJob;
        long jobKey = value.getJobKey();
        if (jobKey > 0L && (stateOfJob = this.jobState.getState(jobKey)) == JobState.State.FAILED) {
            JobRecord job = this.jobState.getJob(jobKey);
            this.jobState.resolve(jobKey, job);
        }
        this.incidentState.deleteIncident(incidentKey);
    }
}

