/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.appliers;

import io.zeebe.engine.state.TypedEventApplier;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import io.zeebe.engine.state.mutable.MutableJobState;
import io.zeebe.engine.state.mutable.MutableVariableState;
import io.zeebe.engine.state.mutable.MutableZeebeState;
import io.zeebe.protocol.impl.record.value.job.JobRecord;
import io.zeebe.protocol.record.intent.JobIntent;
import io.zeebe.protocol.record.intent.ProcessInstanceIntent;

class JobCompletedApplier
implements TypedEventApplier<JobIntent, JobRecord> {
    private final MutableJobState jobState;
    private final MutableElementInstanceState elementInstanceState;
    private final MutableEventScopeInstanceState eventScopeInstanceState;
    private final MutableVariableState variableState;

    JobCompletedApplier(MutableZeebeState state) {
        this.jobState = state.getJobState();
        this.elementInstanceState = state.getElementInstanceState();
        this.eventScopeInstanceState = state.getEventScopeInstanceState();
        this.variableState = state.getVariableState();
    }

    @Override
    public void applyState(long key, JobRecord value) {
        long scopeKey;
        ElementInstance scopeInstance;
        this.jobState.complete(key, value);
        long elementInstanceKey = value.getElementInstanceKey();
        ElementInstance elementInstance = this.elementInstanceState.getInstance(elementInstanceKey);
        if (elementInstance != null && (scopeInstance = this.elementInstanceState.getInstance(scopeKey = elementInstance.getValue().getFlowScopeKey())) != null && scopeInstance.isActive()) {
            elementInstance.setState(ProcessInstanceIntent.ELEMENT_COMPLETING);
            elementInstance.setJobKey(-1L);
            this.elementInstanceState.updateInstance(elementInstance);
            this.eventScopeInstanceState.shutdownInstance(elementInstanceKey);
            this.variableState.setTemporaryVariables(elementInstanceKey, value.getVariablesBuffer());
        }
    }
}

