/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.appliers;

import io.zeebe.engine.processing.deployment.model.element.ExecutableCatchEvent;
import io.zeebe.engine.state.TypedEventApplier;
import io.zeebe.engine.state.analyzers.CatchEventAnalyzer;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import io.zeebe.engine.state.mutable.MutableJobState;
import io.zeebe.engine.state.mutable.MutableZeebeState;
import io.zeebe.protocol.impl.record.value.job.JobRecord;
import io.zeebe.protocol.record.intent.JobIntent;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class JobErrorThrownApplier
implements TypedEventApplier<JobIntent, JobRecord> {
    private static final DirectBuffer NO_VARIABLES = new UnsafeBuffer();
    private final MutableJobState jobState;
    private final MutableElementInstanceState elementInstanceState;
    private final MutableEventScopeInstanceState eventScopeInstanceState;
    private final CatchEventAnalyzer stateAnalyzer;

    JobErrorThrownApplier(MutableZeebeState state) {
        this.jobState = state.getJobState();
        this.elementInstanceState = state.getElementInstanceState();
        this.eventScopeInstanceState = state.getEventScopeInstanceState();
        this.stateAnalyzer = new CatchEventAnalyzer(state.getProcessState(), state.getElementInstanceState());
    }

    @Override
    public void applyState(long jobKey, JobRecord job) {
        String serviceTaskInstanceId = job.getElementId();
        this.jobState.throwError(jobKey, job);
        if (!"NO_CATCH_EVENT_FOUND".equals(serviceTaskInstanceId)) {
            ElementInstance serviceTaskInstance = this.elementInstanceState.getInstance(job.getElementInstanceKey());
            this.removeJobReference(jobKey, job, serviceTaskInstance);
            this.triggerEvent(jobKey, job, serviceTaskInstance);
        }
    }

    private void removeJobReference(long jobKey, JobRecord job, ElementInstance serviceTaskInstance) {
        serviceTaskInstance.setJobKey(-1L);
        this.elementInstanceState.updateInstance(serviceTaskInstance);
        this.jobState.delete(jobKey, job);
    }

    private void triggerEvent(long jobKey, JobRecord job, ElementInstance serviceTaskInstance) {
        CatchEventAnalyzer.CatchEventTuple foundCatchEvent = this.stateAnalyzer.findCatchEvent(job.getErrorCodeBuffer(), serviceTaskInstance);
        ElementInstance eventScopeInstance = foundCatchEvent.getElementInstance();
        ExecutableCatchEvent catchEvent = foundCatchEvent.getCatchEvent();
        this.eventScopeInstanceState.triggerEvent(eventScopeInstance.getKey(), jobKey, catchEvent.getId(), NO_VARIABLES);
    }
}

