/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.appliers;

import io.zeebe.engine.state.TypedEventApplier;
import io.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import io.zeebe.engine.state.mutable.MutableMessageState;
import io.zeebe.protocol.impl.record.value.message.MessageStartEventSubscriptionRecord;
import io.zeebe.protocol.record.intent.MessageStartEventSubscriptionIntent;
import org.agrona.DirectBuffer;

public final class MessageStartEventSubscriptionCorrelatedApplier
implements TypedEventApplier<MessageStartEventSubscriptionIntent, MessageStartEventSubscriptionRecord> {
    private final MutableMessageState messageState;
    private final MutableEventScopeInstanceState eventScopeInstanceState;

    public MessageStartEventSubscriptionCorrelatedApplier(MutableMessageState messageState, MutableEventScopeInstanceState eventScopeInstanceState) {
        this.messageState = messageState;
        this.eventScopeInstanceState = eventScopeInstanceState;
    }

    @Override
    public void applyState(long key, MessageStartEventSubscriptionRecord value) {
        this.messageState.putMessageCorrelation(value.getMessageKey(), value.getBpmnProcessIdBuffer());
        DirectBuffer correlationKey = value.getCorrelationKeyBuffer();
        if (correlationKey.capacity() > 0) {
            this.messageState.putActiveProcessInstance(value.getBpmnProcessIdBuffer(), correlationKey);
            this.messageState.putProcessInstanceCorrelationKey(value.getProcessInstanceKey(), correlationKey);
        }
        this.eventScopeInstanceState.triggerEvent(value.getProcessDefinitionKey(), value.getMessageKey(), value.getStartEventIdBuffer(), value.getVariablesBuffer());
    }
}

