/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.appliers;

import io.zeebe.engine.state.TypedEventApplier;
import io.zeebe.engine.state.mutable.MutableMessageState;
import io.zeebe.engine.state.mutable.MutableMessageSubscriptionState;
import io.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.zeebe.util.sched.clock.ActorClock;

public final class MessageSubscriptionCorrelatingApplier
implements TypedEventApplier<MessageSubscriptionIntent, MessageSubscriptionRecord> {
    private final MutableMessageSubscriptionState messageSubscriptionState;
    private final MutableMessageState messageState;

    public MessageSubscriptionCorrelatingApplier(MutableMessageSubscriptionState messageSubscriptionState, MutableMessageState messageState) {
        this.messageSubscriptionState = messageSubscriptionState;
        this.messageState = messageState;
    }

    @Override
    public void applyState(long key, MessageSubscriptionRecord value) {
        long sentTime = ActorClock.currentTimeMillis();
        this.messageSubscriptionState.updateToCorrelatingState(value, sentTime);
        this.messageState.putMessageCorrelation(value.getMessageKey(), value.getBpmnProcessIdBuffer());
    }
}

