/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.appliers;

import io.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventElement;
import io.zeebe.engine.state.TypedEventApplier;
import io.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import io.zeebe.engine.state.mutable.MutableProcessState;
import io.zeebe.engine.state.mutable.MutableZeebeState;
import io.zeebe.protocol.impl.record.value.deployment.ProcessRecord;
import io.zeebe.protocol.record.intent.ProcessIntent;
import java.util.Collections;

public class ProcessCreatedApplier
implements TypedEventApplier<ProcessIntent, ProcessRecord> {
    private final MutableProcessState processState;
    private final MutableEventScopeInstanceState eventScopeInstanceState;

    public ProcessCreatedApplier(MutableZeebeState state) {
        this.processState = state.getProcessState();
        this.eventScopeInstanceState = state.getEventScopeInstanceState();
    }

    @Override
    public void applyState(long processDefinitionKey, ProcessRecord value) {
        this.processState.putProcess(processDefinitionKey, value);
        boolean hasAtLeastOneTimer = this.processState.getProcessByKey(processDefinitionKey).getProcess().getStartEvents().stream().anyMatch(ExecutableCatchEventElement::isTimer);
        if (hasAtLeastOneTimer) {
            this.eventScopeInstanceState.createIfNotExists(processDefinitionKey, Collections.emptyList());
        }
    }
}

