/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.appliers;

import io.zeebe.engine.processing.deployment.model.element.ExecutableCatchEvent;
import io.zeebe.engine.processing.deployment.model.element.ExecutableFlowElementContainer;
import io.zeebe.engine.state.TypedEventApplier;
import io.zeebe.engine.state.immutable.ProcessState;
import io.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import io.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.zeebe.protocol.record.value.BpmnElementType;
import java.util.List;

final class ProcessInstanceElementActivatedApplier
implements TypedEventApplier<ProcessInstanceIntent, ProcessInstanceRecord> {
    private final MutableElementInstanceState elementInstanceState;
    private final ProcessState processState;
    private final MutableEventScopeInstanceState eventScopeInstanceState;

    public ProcessInstanceElementActivatedApplier(MutableElementInstanceState elementInstanceState, ProcessState processState, MutableEventScopeInstanceState eventScopeInstanceState) {
        this.elementInstanceState = elementInstanceState;
        this.processState = processState;
        this.eventScopeInstanceState = eventScopeInstanceState;
    }

    @Override
    public void applyState(long key, ProcessInstanceRecord value) {
        ExecutableFlowElementContainer executableFlowElementContainer;
        List<ExecutableCatchEvent> events;
        this.elementInstanceState.updateInstance(key, instance -> instance.setState(ProcessInstanceIntent.ELEMENT_ACTIVATED));
        if (value.getBpmnElementType() == BpmnElementType.SUB_PROCESS && !(events = (executableFlowElementContainer = this.processState.getFlowElement(value.getProcessDefinitionKey(), value.getElementIdBuffer(), ExecutableFlowElementContainer.class)).getEvents()).isEmpty()) {
            this.eventScopeInstanceState.createIfNotExists(key, executableFlowElementContainer.getInterruptingElementIds());
        }
    }
}

