/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.appliers;

import io.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;
import io.zeebe.engine.state.TypedEventApplier;
import io.zeebe.engine.state.immutable.ProcessState;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.zeebe.engine.state.mutable.MutableVariableState;
import io.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.zeebe.protocol.record.value.BpmnElementType;
import org.agrona.DirectBuffer;

final class ProcessInstanceElementActivatingApplier
implements TypedEventApplier<ProcessInstanceIntent, ProcessInstanceRecord> {
    private final MutableElementInstanceState elementInstanceState;
    private final MutableVariableState variableState;
    private final ProcessState processState;

    public ProcessInstanceElementActivatingApplier(MutableElementInstanceState elementInstanceState, ProcessState processState, MutableVariableState variableState) {
        this.elementInstanceState = elementInstanceState;
        this.processState = processState;
        this.variableState = variableState;
    }

    @Override
    public void applyState(long elementInstanceKey, ProcessInstanceRecord value) {
        DirectBuffer variables;
        ExecutableStartEvent executableStartEvent;
        BpmnElementType currentElementType;
        ElementInstance flowScopeInstance = this.elementInstanceState.getInstance(value.getFlowScopeKey());
        this.elementInstanceState.newInstance(flowScopeInstance, elementInstanceKey, value, ProcessInstanceIntent.ELEMENT_ACTIVATING);
        if (flowScopeInstance == null) {
            return;
        }
        BpmnElementType flowScopeElementType = flowScopeInstance.getValue().getBpmnElementType();
        if (this.isContainerElement(flowScopeElementType, currentElementType = value.getBpmnElementType()) || this.isNonInterruptingEventSubprocess(flowScopeInstance, currentElementType) || currentElementType == BpmnElementType.BOUNDARY_EVENT || currentElementType == BpmnElementType.INTERMEDIATE_CATCH_EVENT) {
            this.elementInstanceState.spawnToken(flowScopeInstance.getKey());
        }
        if (this.isStartEventInSubProcess(flowScopeElementType, currentElementType) && !(executableStartEvent = this.processState.getFlowElement(value.getProcessDefinitionKey(), value.getElementIdBuffer(), ExecutableStartEvent.class)).isNone() && (variables = this.variableState.getTemporaryVariables(flowScopeInstance.getKey())) != null) {
            this.variableState.setTemporaryVariables(elementInstanceKey, variables);
            this.variableState.removeTemporaryVariables(flowScopeInstance.getKey());
        }
    }

    private boolean isNonInterruptingEventSubprocess(ElementInstance flowScopeInstance, BpmnElementType currentElementType) {
        BpmnElementType flowScopeElementType = flowScopeInstance.getValue().getBpmnElementType();
        return currentElementType == BpmnElementType.SUB_PROCESS && flowScopeElementType == BpmnElementType.PROCESS && !this.isInterrupted(flowScopeInstance);
    }

    private boolean isInterrupted(ElementInstance elementInstance) {
        return elementInstance.getNumberOfActiveTokens() == 2 && elementInstance.isInterrupted() && elementInstance.isActive();
    }

    private boolean isStartEventInSubProcess(BpmnElementType flowScopeElementType, BpmnElementType currentElementType) {
        return currentElementType == BpmnElementType.START_EVENT && flowScopeElementType == BpmnElementType.SUB_PROCESS;
    }

    private boolean isContainerElement(BpmnElementType flowScopeElementType, BpmnElementType currentElementType) {
        return currentElementType == BpmnElementType.START_EVENT && (flowScopeElementType == BpmnElementType.SUB_PROCESS || flowScopeElementType == BpmnElementType.PROCESS) || flowScopeElementType == BpmnElementType.MULTI_INSTANCE_BODY;
    }
}

