/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.appliers;

import io.zeebe.engine.state.TypedEventApplier;
import io.zeebe.engine.state.message.ProcessInstanceSubscription;
import io.zeebe.engine.state.mutable.MutableProcessInstanceSubscriptionState;
import io.zeebe.protocol.impl.record.value.message.ProcessInstanceSubscriptionRecord;
import io.zeebe.protocol.record.intent.ProcessInstanceSubscriptionIntent;
import io.zeebe.util.sched.clock.ActorClock;

public final class ProcessInstanceSubscriptionCreatingApplier
implements TypedEventApplier<ProcessInstanceSubscriptionIntent, ProcessInstanceSubscriptionRecord> {
    private final MutableProcessInstanceSubscriptionState subscriptionState;

    public ProcessInstanceSubscriptionCreatingApplier(MutableProcessInstanceSubscriptionState subscriptionState) {
        this.subscriptionState = subscriptionState;
    }

    @Override
    public void applyState(long key, ProcessInstanceSubscriptionRecord value) {
        ProcessInstanceSubscription subscription = new ProcessInstanceSubscription();
        subscription.setSubscriptionPartitionId(value.getSubscriptionPartitionId());
        subscription.setMessageName(value.getMessageNameBuffer());
        subscription.setElementInstanceKey(value.getElementInstanceKey());
        subscription.setProcessInstanceKey(value.getProcessInstanceKey());
        subscription.setBpmnProcessId(value.getBpmnProcessIdBuffer());
        subscription.setCorrelationKey(value.getCorrelationKeyBuffer());
        subscription.setTargetElementId(value.getElementIdBuffer());
        subscription.setCloseOnCorrelate(value.isInterrupting());
        long sentTime = ActorClock.currentTimeMillis();
        subscription.setCommandSentTime(sentTime);
        if (this.subscriptionState.existSubscriptionForElementInstance(value.getElementInstanceKey(), value.getMessageNameBuffer())) {
            return;
        }
        this.subscriptionState.put(subscription);
    }
}

