/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.deployment;

import io.zeebe.db.ColumnFamily;
import io.zeebe.db.DbKey;
import io.zeebe.db.DbValue;
import io.zeebe.db.TransactionContext;
import io.zeebe.db.ZeebeDb;
import io.zeebe.db.impl.DbCompositeKey;
import io.zeebe.db.impl.DbLong;
import io.zeebe.db.impl.DbString;
import io.zeebe.engine.processing.deployment.model.BpmnFactory;
import io.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.zeebe.engine.processing.deployment.model.transformation.BpmnTransformer;
import io.zeebe.engine.state.NextValueManager;
import io.zeebe.engine.state.ZbColumnFamilies;
import io.zeebe.engine.state.deployment.DeployedProcess;
import io.zeebe.engine.state.deployment.Digest;
import io.zeebe.engine.state.deployment.PersistedProcess;
import io.zeebe.engine.state.mutable.MutableProcessState;
import io.zeebe.model.bpmn.Bpmn;
import io.zeebe.model.bpmn.BpmnModelInstance;
import io.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.zeebe.protocol.impl.record.value.deployment.ProcessRecord;
import io.zeebe.util.buffer.BufferUtil;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.io.DirectBufferInputStream;

public final class DbProcessState
implements MutableProcessState {
    private static final int DEFAULT_VERSION_VALUE = 0;
    private final BpmnTransformer transformer = BpmnFactory.createTransformer();
    private final Map<DirectBuffer, Long2ObjectHashMap<DeployedProcess>> processesByProcessIdAndVersion = new HashMap<DirectBuffer, Long2ObjectHashMap<DeployedProcess>>();
    private final Long2ObjectHashMap<DeployedProcess> processesByKey;
    private final ColumnFamily<DbLong, PersistedProcess> processColumnFamily;
    private final DbLong processDefinitionKey;
    private final PersistedProcess persistedProcess;
    private final ColumnFamily<DbCompositeKey<DbString, DbLong>, PersistedProcess> processByIdAndVersionColumnFamily;
    private final DbLong processVersion;
    private final DbCompositeKey<DbString, DbLong> idAndVersionKey;
    private final DbString processId;
    private final ColumnFamily<DbString, Digest> digestByIdColumnFamily;
    private final Digest digest = new Digest();
    private final NextValueManager versionManager;

    public DbProcessState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.processDefinitionKey = new DbLong();
        this.persistedProcess = new PersistedProcess();
        this.processColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.PROCESS_CACHE, transactionContext, (DbKey)this.processDefinitionKey, (DbValue)this.persistedProcess);
        this.processId = new DbString();
        this.processVersion = new DbLong();
        this.idAndVersionKey = new DbCompositeKey((DbKey)this.processId, (DbKey)this.processVersion);
        this.processByIdAndVersionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.PROCESS_CACHE_BY_ID_AND_VERSION, transactionContext, this.idAndVersionKey, (DbValue)this.persistedProcess);
        this.digestByIdColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.PROCESS_CACHE_DIGEST_BY_ID, transactionContext, (DbKey)this.processId, (DbValue)this.digest);
        this.processesByKey = new Long2ObjectHashMap();
        this.versionManager = new NextValueManager(0L, zeebeDb, transactionContext, ZbColumnFamilies.PROCESS_VERSION);
    }

    @Override
    public void putDeployment(DeploymentRecord deploymentRecord) {
        for (ProcessRecord processRecord : deploymentRecord.processes()) {
            this.putProcess(processRecord.getKey(), processRecord);
        }
    }

    @Override
    public void putProcess(long key, ProcessRecord processRecord) {
        this.persistProcess(key, processRecord);
        this.updateLatestVersion(processRecord);
        this.putLatestVersionDigest(processRecord.getBpmnProcessIdBuffer(), processRecord.getChecksumBuffer());
    }

    private void persistProcess(long processDefinitionKey, ProcessRecord processRecord) {
        this.persistedProcess.wrap(processRecord, processDefinitionKey);
        this.processDefinitionKey.wrapLong(processDefinitionKey);
        this.processColumnFamily.put((DbKey)this.processDefinitionKey, (DbValue)this.persistedProcess);
        this.processId.wrapBuffer(processRecord.getBpmnProcessIdBuffer());
        this.processVersion.wrapLong((long)processRecord.getVersion());
        this.processByIdAndVersionColumnFamily.put(this.idAndVersionKey, (DbValue)this.persistedProcess);
    }

    private void updateLatestVersion(ProcessRecord processRecord) {
        this.processId.wrapBuffer(processRecord.getBpmnProcessIdBuffer());
        String bpmnProcessId = processRecord.getBpmnProcessId();
        long currentVersion = this.versionManager.getCurrentValue(bpmnProcessId);
        int nextVersion = processRecord.getVersion();
        if ((long)nextVersion > currentVersion) {
            this.versionManager.setValue(bpmnProcessId, nextVersion);
        }
    }

    private DeployedProcess updateInMemoryState(PersistedProcess persistedProcess) {
        byte[] bytes = new byte[persistedProcess.getLength()];
        UnsafeBuffer buffer = new UnsafeBuffer(bytes);
        persistedProcess.write((MutableDirectBuffer)buffer, 0);
        PersistedProcess copiedProcess = new PersistedProcess();
        copiedProcess.wrap((DirectBuffer)buffer, 0, persistedProcess.getLength());
        BpmnModelInstance modelInstance = this.readModelInstanceFromBuffer(copiedProcess.getResource());
        List<ExecutableProcess> definitions = this.transformer.transformDefinitions(modelInstance);
        ExecutableProcess executableProcess = definitions.stream().filter(w -> BufferUtil.equals((DirectBuffer)persistedProcess.getBpmnProcessId(), (DirectBuffer)w.getId())).findFirst().orElseThrow();
        DeployedProcess deployedProcess = new DeployedProcess(executableProcess, copiedProcess);
        this.addProcessToInMemoryState(deployedProcess);
        return deployedProcess;
    }

    private BpmnModelInstance readModelInstanceFromBuffer(DirectBuffer buffer) {
        try (DirectBufferInputStream stream = new DirectBufferInputStream(buffer);){
            BpmnModelInstance bpmnModelInstance = Bpmn.readModelFromStream((InputStream)stream);
            return bpmnModelInstance;
        }
    }

    private void addProcessToInMemoryState(DeployedProcess deployedProcess) {
        DirectBuffer bpmnProcessId = deployedProcess.getBpmnProcessId();
        this.processesByKey.put(deployedProcess.getKey(), (Object)deployedProcess);
        Long2ObjectHashMap versionMap = this.processesByProcessIdAndVersion.computeIfAbsent(bpmnProcessId, id -> new Long2ObjectHashMap());
        int version = deployedProcess.getVersion();
        versionMap.put((long)version, (Object)deployedProcess);
    }

    @Override
    public DeployedProcess getLatestProcessVersionByProcessId(DirectBuffer processIdBuffer) {
        DeployedProcess deployedProcess;
        Long2ObjectHashMap<DeployedProcess> versionMap = this.processesByProcessIdAndVersion.get(processIdBuffer);
        this.processId.wrapBuffer(processIdBuffer);
        long latestVersion = this.versionManager.getCurrentValue(processIdBuffer);
        if (versionMap == null) {
            deployedProcess = this.lookupProcessByIdAndPersistedVersion(latestVersion);
        } else {
            deployedProcess = (DeployedProcess)versionMap.get(latestVersion);
            if (deployedProcess == null) {
                deployedProcess = this.lookupProcessByIdAndPersistedVersion(latestVersion);
            }
        }
        return deployedProcess;
    }

    private DeployedProcess lookupProcessByIdAndPersistedVersion(long latestVersion) {
        this.processVersion.wrapLong(latestVersion);
        PersistedProcess processWithVersionAndId = (PersistedProcess)this.processByIdAndVersionColumnFamily.get(this.idAndVersionKey);
        if (processWithVersionAndId != null) {
            return this.updateInMemoryState(processWithVersionAndId);
        }
        return null;
    }

    @Override
    public DeployedProcess getProcessByProcessIdAndVersion(DirectBuffer processId, int version) {
        Long2ObjectHashMap<DeployedProcess> versionMap = this.processesByProcessIdAndVersion.get(processId);
        if (versionMap != null) {
            DeployedProcess deployedProcess = (DeployedProcess)versionMap.get((long)version);
            return deployedProcess != null ? deployedProcess : this.lookupPersistenceState(processId, version);
        }
        return this.lookupPersistenceState(processId, version);
    }

    private DeployedProcess lookupPersistenceState(DirectBuffer processIdBuffer, int version) {
        this.processId.wrapBuffer(processIdBuffer);
        this.processVersion.wrapLong((long)version);
        PersistedProcess processWithVersionAndId = (PersistedProcess)this.processByIdAndVersionColumnFamily.get(this.idAndVersionKey);
        if (processWithVersionAndId != null) {
            this.updateInMemoryState(processWithVersionAndId);
            Long2ObjectHashMap<DeployedProcess> newVersionMap = this.processesByProcessIdAndVersion.get(processIdBuffer);
            if (newVersionMap != null) {
                return (DeployedProcess)newVersionMap.get((long)version);
            }
        }
        return null;
    }

    @Override
    public DeployedProcess getProcessByKey(long key) {
        DeployedProcess deployedProcess = (DeployedProcess)this.processesByKey.get(key);
        if (deployedProcess != null) {
            return deployedProcess;
        }
        return this.lookupPersistenceStateForProcessByKey(key);
    }

    private DeployedProcess lookupPersistenceStateForProcessByKey(long processDefinitionKey) {
        this.processDefinitionKey.wrapLong(processDefinitionKey);
        PersistedProcess processWithKey = (PersistedProcess)this.processColumnFamily.get((DbKey)this.processDefinitionKey);
        if (processWithKey != null) {
            this.updateInMemoryState(processWithKey);
            return (DeployedProcess)this.processesByKey.get(processDefinitionKey);
        }
        return null;
    }

    @Override
    public Collection<DeployedProcess> getProcesses() {
        this.updateCompleteInMemoryState();
        return this.processesByKey.values();
    }

    @Override
    public Collection<DeployedProcess> getProcessesByBpmnProcessId(DirectBuffer bpmnProcessId) {
        this.updateCompleteInMemoryState();
        Long2ObjectHashMap<DeployedProcess> processesByVersions = this.processesByProcessIdAndVersion.get(bpmnProcessId);
        if (processesByVersions != null) {
            return processesByVersions.values();
        }
        return Collections.emptyList();
    }

    private void updateCompleteInMemoryState() {
        this.processColumnFamily.forEach(this::updateInMemoryState);
    }

    @Override
    public void putLatestVersionDigest(DirectBuffer processIdBuffer, DirectBuffer digest) {
        this.processId.wrapBuffer(processIdBuffer);
        this.digest.set(digest);
        this.digestByIdColumnFamily.put((DbKey)this.processId, (DbValue)this.digest);
    }

    @Override
    public DirectBuffer getLatestVersionDigest(DirectBuffer processIdBuffer) {
        this.processId.wrapBuffer(processIdBuffer);
        Digest latestDigest = (Digest)this.digestByIdColumnFamily.get((DbKey)this.processId);
        return latestDigest == null || this.digest.get().byteArray() == null ? null : latestDigest.get();
    }

    @Override
    public int getProcessVersion(String bpmnProcessId) {
        return (int)this.versionManager.getCurrentValue(bpmnProcessId);
    }

    @Override
    public <T extends ExecutableFlowElement> T getFlowElement(long processDefinitionKey, DirectBuffer elementId, Class<T> elementType) {
        DeployedProcess deployedProcess = this.getProcessByKey(processDefinitionKey);
        if (deployedProcess == null) {
            throw new IllegalStateException(String.format("Expected to find a process deployed with key '%d' but not found.", processDefinitionKey));
        }
        ExecutableProcess process = deployedProcess.getProcess();
        T element = process.getElementById(elementId, elementType);
        if (element == null) {
            throw new IllegalStateException(String.format("Expected to find a flow element with id '%s' in process with key '%d' but not found.", BufferUtil.bufferAsString((DirectBuffer)elementId), processDefinitionKey));
        }
        return element;
    }
}

