/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.instance;

import io.zeebe.db.ColumnFamily;
import io.zeebe.db.DbKey;
import io.zeebe.db.DbValue;
import io.zeebe.db.TransactionContext;
import io.zeebe.db.ZeebeDb;
import io.zeebe.db.impl.DbByte;
import io.zeebe.db.impl.DbCompositeKey;
import io.zeebe.db.impl.DbLong;
import io.zeebe.db.impl.DbNil;
import io.zeebe.engine.state.ZbColumnFamilies;
import io.zeebe.engine.state.instance.AwaitProcessInstanceResultMetadata;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.engine.state.instance.IndexedRecord;
import io.zeebe.engine.state.instance.StoredRecord;
import io.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.zeebe.engine.state.mutable.MutableVariableState;
import io.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.zeebe.protocol.record.intent.ProcessInstanceIntent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class DbElementInstanceState
implements MutableElementInstanceState {
    private final ColumnFamily<DbCompositeKey<DbLong, DbLong>, DbNil> parentChildColumnFamily;
    private final DbCompositeKey<DbLong, DbLong> parentChildKey;
    private final DbLong parentKey;
    private final DbLong elementInstanceKey;
    private final ElementInstance elementInstance;
    private final ColumnFamily<DbLong, ElementInstance> elementInstanceColumnFamily;
    private final DbLong recordKey;
    private final StoredRecord storedRecord;
    private final ColumnFamily<DbLong, StoredRecord> recordColumnFamily;
    private final DbLong recordParentKey;
    private final DbCompositeKey<DbCompositeKey<DbLong, DbByte>, DbLong> recordParentStateRecordKey;
    private final DbByte stateKey;
    private final DbCompositeKey<DbLong, DbByte> recordParentStateKey;
    private final ColumnFamily<DbCompositeKey<DbCompositeKey<DbLong, DbByte>, DbLong>, DbNil> recordParentChildColumnFamily;
    private final AwaitProcessInstanceResultMetadata awaitResultMetadata;
    private final ColumnFamily<DbLong, AwaitProcessInstanceResultMetadata> awaitProcessInstanceResultMetadataColumnFamily;
    private final MutableVariableState variableState;

    public DbElementInstanceState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext, MutableVariableState variableState) {
        this.variableState = variableState;
        this.elementInstanceKey = new DbLong();
        this.parentKey = new DbLong();
        this.parentChildKey = new DbCompositeKey((DbKey)this.parentKey, (DbKey)this.elementInstanceKey);
        this.parentChildColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.ELEMENT_INSTANCE_PARENT_CHILD, transactionContext, this.parentChildKey, (DbValue)DbNil.INSTANCE);
        this.elementInstance = new ElementInstance();
        this.elementInstanceColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.ELEMENT_INSTANCE_KEY, transactionContext, (DbKey)this.elementInstanceKey, (DbValue)this.elementInstance);
        this.recordKey = new DbLong();
        this.storedRecord = new StoredRecord();
        this.recordColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.STORED_INSTANCE_EVENTS, transactionContext, (DbKey)this.recordKey, (DbValue)this.storedRecord);
        this.recordParentKey = new DbLong();
        this.stateKey = new DbByte();
        this.recordParentStateKey = new DbCompositeKey((DbKey)this.recordParentKey, (DbKey)this.stateKey);
        this.recordParentStateRecordKey = new DbCompositeKey(this.recordParentStateKey, (DbKey)this.recordKey);
        this.recordParentChildColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.STORED_INSTANCE_EVENTS_PARENT_CHILD, transactionContext, this.recordParentStateRecordKey, (DbValue)DbNil.INSTANCE);
        this.awaitResultMetadata = new AwaitProcessInstanceResultMetadata();
        this.awaitProcessInstanceResultMetadataColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.AWAIT_WORKLOW_RESULT, transactionContext, (DbKey)this.elementInstanceKey, (DbValue)this.awaitResultMetadata);
    }

    @Override
    public ElementInstance newInstance(long key, ProcessInstanceRecord value, ProcessInstanceIntent state) {
        return this.newInstance(null, key, value, state);
    }

    @Override
    public ElementInstance newInstance(ElementInstance parent, long key, ProcessInstanceRecord value, ProcessInstanceIntent state) {
        ElementInstance instance;
        if (parent == null) {
            instance = new ElementInstance(key, state, value);
        } else {
            instance = new ElementInstance(key, parent, state, value);
            this.updateInstance(parent);
        }
        this.updateInstance(instance);
        return instance;
    }

    @Override
    public void removeInstance(long key) {
        ElementInstance instance = this.getInstance(key);
        if (instance != null) {
            this.elementInstanceKey.wrapLong(key);
            this.parentKey.wrapLong(instance.getParentKey());
            this.parentChildColumnFamily.delete(this.parentChildKey);
            this.elementInstanceColumnFamily.delete((DbKey)this.elementInstanceKey);
            this.recordParentChildColumnFamily.whileEqualPrefix((DbKey)this.elementInstanceKey, (compositeKey, nil) -> {
                this.recordParentChildColumnFamily.delete((DbKey)compositeKey);
                this.recordColumnFamily.delete((DbKey)((DbLong)compositeKey.getSecond()));
            });
            this.variableState.removeScope(key);
            this.awaitProcessInstanceResultMetadataColumnFamily.delete((DbKey)this.elementInstanceKey);
            long parentKey = instance.getParentKey();
            if (parentKey > 0L) {
                ElementInstance parentInstance = this.getInstance(parentKey);
                if (parentInstance == null) {
                    String errorMsg = "Expected to find parent instance for element instance with key %d, but none was found.";
                    throw new IllegalStateException(String.format("Expected to find parent instance for element instance with key %d, but none was found.", parentKey));
                }
                parentInstance.decrementChildCount();
                this.updateInstance(parentInstance);
            }
        }
    }

    @Override
    public void updateInstance(ElementInstance scopeInstance) {
        this.writeElementInstance(scopeInstance);
    }

    @Override
    public void updateInstance(long key, Consumer<ElementInstance> modifier) {
        ElementInstance scopeInstance = this.getInstance(key);
        modifier.accept(scopeInstance);
        this.updateInstance(scopeInstance);
    }

    @Override
    public void consumeToken(long scopeKey) {
        ElementInstance elementInstance = this.getInstance(scopeKey);
        if (elementInstance != null) {
            elementInstance.consumeToken();
            this.updateInstance(elementInstance);
        }
    }

    @Override
    public void spawnToken(long scopeKey) {
        ElementInstance elementInstance = this.getInstance(scopeKey);
        if (elementInstance != null) {
            elementInstance.spawnToken();
            this.updateInstance(elementInstance);
        }
    }

    @Override
    public void storeRecord(long key, long scopeKey, ProcessInstanceRecord value, ProcessInstanceIntent intent, StoredRecord.Purpose purpose) {
        IndexedRecord indexedRecord = new IndexedRecord(key, intent, value);
        StoredRecord storedRecord = new StoredRecord(indexedRecord, purpose);
        this.setRecordKeys(scopeKey, key, purpose);
        this.recordColumnFamily.put((DbKey)this.recordKey, (DbValue)storedRecord);
        this.recordParentChildColumnFamily.put(this.recordParentStateRecordKey, (DbValue)DbNil.INSTANCE);
    }

    @Override
    public void removeStoredRecord(long scopeKey, long recordKey, StoredRecord.Purpose purpose) {
        this.setRecordKeys(scopeKey, recordKey, purpose);
        this.recordColumnFamily.delete((DbKey)this.recordKey);
        this.recordParentChildColumnFamily.delete(this.recordParentStateRecordKey);
    }

    @Override
    public void setAwaitResultRequestMetadata(long processInstanceKey, AwaitProcessInstanceResultMetadata metadata) {
        this.elementInstanceKey.wrapLong(processInstanceKey);
        this.awaitProcessInstanceResultMetadataColumnFamily.put((DbKey)this.elementInstanceKey, (DbValue)metadata);
    }

    private void writeElementInstance(ElementInstance instance) {
        this.elementInstanceKey.wrapLong(instance.getKey());
        this.parentKey.wrapLong(instance.getParentKey());
        this.elementInstanceColumnFamily.put((DbKey)this.elementInstanceKey, (DbValue)instance);
        this.parentChildColumnFamily.put(this.parentChildKey, (DbValue)DbNil.INSTANCE);
        this.variableState.createScope(this.elementInstanceKey.getValue(), this.parentKey.getValue());
    }

    @Override
    public ElementInstance getInstance(long key) {
        this.elementInstanceKey.wrapLong(key);
        ElementInstance elementInstance = (ElementInstance)this.elementInstanceColumnFamily.get((DbKey)this.elementInstanceKey);
        return this.copyElementInstance(elementInstance);
    }

    @Override
    public StoredRecord getStoredRecord(long recordKey) {
        this.recordKey.wrapLong(recordKey);
        return (StoredRecord)this.recordColumnFamily.get((DbKey)this.recordKey);
    }

    @Override
    public List<ElementInstance> getChildren(long parentKey) {
        ArrayList<ElementInstance> children = new ArrayList<ElementInstance>();
        ElementInstance parentInstance = this.getInstance(parentKey);
        if (parentInstance != null) {
            this.parentKey.wrapLong(parentKey);
            this.parentChildColumnFamily.whileEqualPrefix((DbKey)this.parentKey, (key, value) -> {
                DbLong childKey = (DbLong)key.getSecond();
                ElementInstance childInstance = this.getInstance(childKey.getValue());
                ElementInstance copiedElementInstance = this.copyElementInstance(childInstance);
                children.add(copiedElementInstance);
            });
        }
        return children;
    }

    @Override
    public List<IndexedRecord> getDeferredRecords(long scopeKey) {
        return this.collectRecords(scopeKey, StoredRecord.Purpose.DEFERRED);
    }

    @Override
    public IndexedRecord getFailedRecord(long key) {
        StoredRecord storedRecord = this.getStoredRecord(key);
        if (storedRecord != null && storedRecord.getPurpose() == StoredRecord.Purpose.FAILED) {
            return storedRecord.getRecord();
        }
        return null;
    }

    @Override
    public AwaitProcessInstanceResultMetadata getAwaitResultRequestMetadata(long processInstanceKey) {
        this.elementInstanceKey.wrapLong(processInstanceKey);
        return (AwaitProcessInstanceResultMetadata)this.awaitProcessInstanceResultMetadataColumnFamily.get((DbKey)this.elementInstanceKey);
    }

    private void setRecordKeys(long scopeKey, long recordKey, StoredRecord.Purpose purpose) {
        this.recordParentKey.wrapLong(scopeKey);
        this.stateKey.wrapByte((byte)purpose.ordinal());
        this.recordKey.wrapLong(recordKey);
    }

    private List<IndexedRecord> collectRecords(long scopeKey, StoredRecord.Purpose purpose) {
        ArrayList<IndexedRecord> records = new ArrayList<IndexedRecord>();
        this.visitRecords(scopeKey, purpose, indexedRecord -> {
            byte[] bytes = new byte[indexedRecord.getLength()];
            UnsafeBuffer buffer = new UnsafeBuffer(bytes);
            indexedRecord.write((MutableDirectBuffer)buffer, 0);
            IndexedRecord copiedRecord = new IndexedRecord();
            copiedRecord.wrap((DirectBuffer)buffer, 0, indexedRecord.getLength());
            records.add(copiedRecord);
        });
        return records;
    }

    private void visitRecords(long scopeKey, StoredRecord.Purpose purpose, RecordVisitor visitor) {
        this.recordParentKey.wrapLong(scopeKey);
        this.stateKey.wrapByte((byte)purpose.ordinal());
        this.recordParentChildColumnFamily.whileEqualPrefix(this.recordParentStateKey, (compositeKey, value) -> {
            DbLong recordKey = (DbLong)compositeKey.getSecond();
            StoredRecord storedRecord = (StoredRecord)this.recordColumnFamily.get((DbKey)recordKey);
            if (storedRecord != null) {
                visitor.visitRecord(storedRecord.getRecord());
            }
        });
    }

    private ElementInstance copyElementInstance(ElementInstance elementInstance) {
        if (elementInstance != null) {
            byte[] bytes = new byte[elementInstance.getLength()];
            UnsafeBuffer buffer = new UnsafeBuffer(bytes);
            elementInstance.write((MutableDirectBuffer)buffer, 0);
            ElementInstance copiedElementInstance = new ElementInstance();
            copiedElementInstance.wrap((DirectBuffer)buffer, 0, elementInstance.getLength());
            return copiedElementInstance;
        }
        return null;
    }

    @FunctionalInterface
    public static interface RecordVisitor {
        public void visitRecord(IndexedRecord var1);
    }
}

