/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.instance;

import io.zeebe.db.ColumnFamily;
import io.zeebe.db.DbKey;
import io.zeebe.db.DbValue;
import io.zeebe.db.TransactionContext;
import io.zeebe.db.ZeebeDb;
import io.zeebe.db.impl.DbLong;
import io.zeebe.engine.metrics.IncidentMetrics;
import io.zeebe.engine.state.ZbColumnFamilies;
import io.zeebe.engine.state.instance.Incident;
import io.zeebe.engine.state.instance.IncidentKey;
import io.zeebe.engine.state.mutable.MutableIncidentState;
import io.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import java.util.function.ObjLongConsumer;

public final class DbIncidentState
implements MutableIncidentState {
    public static final int MISSING_INCIDENT = -1;
    private final DbLong incidentKey;
    private final Incident incidentRead = new Incident();
    private final Incident incidentWrite = new Incident();
    private final ColumnFamily<DbLong, Incident> incidentColumnFamily;
    private final DbLong elementInstanceKey;
    private final ColumnFamily<DbLong, IncidentKey> processInstanceIncidentColumnFamily;
    private final DbLong jobKey;
    private final ColumnFamily<DbLong, IncidentKey> jobIncidentColumnFamily;
    private final IncidentKey incidentKeyValue = new IncidentKey();
    private final IncidentMetrics metrics;

    public DbIncidentState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext, int partitionId) {
        this.incidentKey = new DbLong();
        this.incidentColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.INCIDENTS, transactionContext, (DbKey)this.incidentKey, (DbValue)this.incidentRead);
        this.elementInstanceKey = new DbLong();
        this.processInstanceIncidentColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.INCIDENT_PROCESS_INSTANCES, transactionContext, (DbKey)this.elementInstanceKey, (DbValue)this.incidentKeyValue);
        this.jobKey = new DbLong();
        this.jobIncidentColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.INCIDENT_JOBS, transactionContext, (DbKey)this.jobKey, (DbValue)this.incidentKeyValue);
        this.metrics = new IncidentMetrics(partitionId);
    }

    @Override
    public void createIncident(long incidentKey, IncidentRecord incident) {
        this.incidentKey.wrapLong(incidentKey);
        this.incidentWrite.setRecord(incident);
        this.incidentColumnFamily.put((DbKey)this.incidentKey, (DbValue)this.incidentWrite);
        this.incidentKeyValue.set(incidentKey);
        if (this.isJobIncident(incident)) {
            this.jobKey.wrapLong(incident.getJobKey());
            this.jobIncidentColumnFamily.put((DbKey)this.jobKey, (DbValue)this.incidentKeyValue);
        } else {
            this.elementInstanceKey.wrapLong(incident.getElementInstanceKey());
            this.processInstanceIncidentColumnFamily.put((DbKey)this.elementInstanceKey, (DbValue)this.incidentKeyValue);
        }
        this.metrics.incidentCreated();
    }

    @Override
    public IncidentRecord getIncidentRecord(long incidentKey) {
        this.incidentKey.wrapLong(incidentKey);
        Incident incident = (Incident)this.incidentColumnFamily.get((DbKey)this.incidentKey);
        if (incident != null) {
            return incident.getRecord();
        }
        return null;
    }

    @Override
    public void deleteIncident(long key) {
        IncidentRecord incidentRecord = this.getIncidentRecord(key);
        if (incidentRecord != null) {
            this.incidentColumnFamily.delete((DbKey)this.incidentKey);
            if (this.isJobIncident(incidentRecord)) {
                this.jobKey.wrapLong(incidentRecord.getJobKey());
                this.jobIncidentColumnFamily.delete((DbKey)this.jobKey);
            } else {
                this.elementInstanceKey.wrapLong(incidentRecord.getElementInstanceKey());
                this.processInstanceIncidentColumnFamily.delete((DbKey)this.elementInstanceKey);
            }
            this.metrics.incidentResolved();
        }
    }

    @Override
    public long getProcessInstanceIncidentKey(long processInstanceKey) {
        this.elementInstanceKey.wrapLong(processInstanceKey);
        IncidentKey incidentKey = (IncidentKey)this.processInstanceIncidentColumnFamily.get((DbKey)this.elementInstanceKey);
        if (incidentKey != null) {
            return incidentKey.get();
        }
        return -1L;
    }

    @Override
    public long getJobIncidentKey(long jobKey) {
        this.jobKey.wrapLong(jobKey);
        IncidentKey incidentKey = (IncidentKey)this.jobIncidentColumnFamily.get((DbKey)this.jobKey);
        if (incidentKey != null) {
            return incidentKey.get();
        }
        return -1L;
    }

    @Override
    public boolean isJobIncident(IncidentRecord record) {
        return record.getJobKey() > 0L;
    }

    @Override
    public void forExistingProcessIncident(long elementInstanceKey, ObjLongConsumer<IncidentRecord> resolver) {
        boolean hasIncident;
        long processIncidentKey = this.getProcessInstanceIncidentKey(elementInstanceKey);
        boolean bl = hasIncident = processIncidentKey != -1L;
        if (hasIncident) {
            IncidentRecord incidentRecord = this.getIncidentRecord(processIncidentKey);
            resolver.accept(incidentRecord, processIncidentKey);
        }
    }
}

