/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.instance;

import io.zeebe.db.DbValue;
import io.zeebe.engine.processing.bpmn.ProcessInstanceLifecycle;
import io.zeebe.engine.state.instance.IndexedRecord;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.msgpack.property.BaseProperty;
import io.zeebe.msgpack.property.IntegerProperty;
import io.zeebe.msgpack.property.LongProperty;
import io.zeebe.msgpack.property.ObjectProperty;
import io.zeebe.msgpack.value.ObjectValue;
import io.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.zeebe.protocol.record.intent.ProcessInstanceIntent;

public final class ElementInstance
extends UnpackedObject
implements DbValue {
    private final LongProperty parentKeyProp = new LongProperty("parentKey", -1L);
    private final IntegerProperty childCountProp = new IntegerProperty("childCount", 0);
    private final LongProperty jobKeyProp = new LongProperty("jobKey", 0L);
    private final IntegerProperty activeTokensProp = new IntegerProperty("activeTokens", 0);
    private final IntegerProperty multiInstanceLoopCounterProp = new IntegerProperty("multiInstanceLoopCounter", 0);
    private final LongProperty interruptingEventKeyProp = new LongProperty("interruptingEventKey", -1L);
    private final LongProperty calledChildInstanceKeyProp = new LongProperty("calledChildInstanceKey", -1L);
    private final ObjectProperty<IndexedRecord> recordProp = new ObjectProperty("elementRecord", (ObjectValue)new IndexedRecord());

    ElementInstance() {
        this.declareProperty((BaseProperty)this.parentKeyProp).declareProperty((BaseProperty)this.childCountProp).declareProperty((BaseProperty)this.jobKeyProp).declareProperty((BaseProperty)this.activeTokensProp).declareProperty((BaseProperty)this.multiInstanceLoopCounterProp).declareProperty((BaseProperty)this.interruptingEventKeyProp).declareProperty((BaseProperty)this.calledChildInstanceKeyProp).declareProperty(this.recordProp);
    }

    public ElementInstance(long key, ElementInstance parent, ProcessInstanceIntent state, ProcessInstanceRecord value) {
        this();
        ((IndexedRecord)this.recordProp.getValue()).setKey(key);
        ((IndexedRecord)this.recordProp.getValue()).setState(state);
        ((IndexedRecord)this.recordProp.getValue()).setValue(value);
        if (parent != null) {
            this.parentKeyProp.setValue(parent.getKey());
            parent.childCountProp.increment();
        }
    }

    public ElementInstance(long key, ProcessInstanceIntent state, ProcessInstanceRecord value) {
        this(key, null, state, value);
    }

    public long getKey() {
        return ((IndexedRecord)this.recordProp.getValue()).getKey();
    }

    public ProcessInstanceIntent getState() {
        return ((IndexedRecord)this.recordProp.getValue()).getState();
    }

    public void setState(ProcessInstanceIntent state) {
        ((IndexedRecord)this.recordProp.getValue()).setState(state);
    }

    public ProcessInstanceRecord getValue() {
        return ((IndexedRecord)this.recordProp.getValue()).getValue();
    }

    public void setValue(ProcessInstanceRecord value) {
        ((IndexedRecord)this.recordProp.getValue()).setValue(value);
    }

    public long getJobKey() {
        return this.jobKeyProp.getValue();
    }

    public void setJobKey(long jobKey) {
        this.jobKeyProp.setValue(jobKey);
    }

    public void decrementChildCount() {
        int childCount = this.childCountProp.decrement();
        if (childCount < 0) {
            throw new IllegalStateException(String.format("Expected the child count to be positive but was %d", childCount));
        }
    }

    public boolean canTerminate() {
        return ProcessInstanceLifecycle.canTerminate(this.getState());
    }

    public boolean isActive() {
        return ProcessInstanceLifecycle.isActive(this.getState());
    }

    public boolean isTerminating() {
        return ProcessInstanceLifecycle.isTerminating(this.getState());
    }

    public boolean isInFinalState() {
        return ProcessInstanceLifecycle.isFinalState(this.getState());
    }

    public void spawnToken() {
        this.activeTokensProp.increment();
    }

    public void consumeToken() {
        int activeTokens = this.activeTokensProp.decrement();
        if (activeTokens < 0) {
            throw new IllegalStateException(String.format("Expected the active token count to be positive but was %d", activeTokens));
        }
    }

    public int getNumberOfActiveTokens() {
        return this.activeTokensProp.getValue();
    }

    public int getNumberOfActiveElementInstances() {
        return this.childCountProp.getValue();
    }

    public int getNumberOfActiveExecutionPaths() {
        return this.activeTokensProp.getValue() + this.childCountProp.getValue();
    }

    public int getMultiInstanceLoopCounter() {
        return this.multiInstanceLoopCounterProp.getValue();
    }

    public void setMultiInstanceLoopCounter(int loopCounter) {
        this.multiInstanceLoopCounterProp.setValue(loopCounter);
    }

    public void incrementMultiInstanceLoopCounter() {
        this.multiInstanceLoopCounterProp.increment();
    }

    public long getCalledChildInstanceKey() {
        return this.calledChildInstanceKeyProp.getValue();
    }

    public void setCalledChildInstanceKey(long calledChildInstanceKey) {
        this.calledChildInstanceKeyProp.setValue(calledChildInstanceKey);
    }

    public long getInterruptingEventKey() {
        return this.interruptingEventKeyProp.getValue();
    }

    public void setInterruptingEventKey(long key) {
        this.interruptingEventKeyProp.setValue(key);
    }

    public boolean isInterrupted() {
        return this.getInterruptingEventKey() > 0L;
    }

    public long getParentKey() {
        return this.parentKeyProp.getValue();
    }
}

