/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.instance;

import io.zeebe.db.DbValue;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.msgpack.property.BaseProperty;
import io.zeebe.msgpack.property.EnumProperty;
import io.zeebe.msgpack.property.LongProperty;
import io.zeebe.msgpack.property.ObjectProperty;
import io.zeebe.msgpack.value.ObjectValue;
import io.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.zeebe.protocol.record.intent.ProcessInstanceIntent;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class IndexedRecord
extends UnpackedObject
implements DbValue {
    private final LongProperty keyProp = new LongProperty("key", 0L);
    private final EnumProperty<ProcessInstanceIntent> stateProp = new EnumProperty("state", ProcessInstanceIntent.class);
    private final ObjectProperty<ProcessInstanceRecord> valueProp = new ObjectProperty("processInstanceRecord", (ObjectValue)new ProcessInstanceRecord());

    IndexedRecord() {
        this.declareProperty((BaseProperty)this.keyProp).declareProperty(this.stateProp).declareProperty(this.valueProp);
    }

    public IndexedRecord(long key, ProcessInstanceIntent instanceState, ProcessInstanceRecord record) {
        this();
        this.keyProp.setValue(key);
        this.stateProp.setValue((Enum)instanceState);
        this.setValue(record);
    }

    public long getKey() {
        return this.keyProp.getValue();
    }

    public IndexedRecord setKey(long key) {
        this.keyProp.setValue(key);
        return this;
    }

    public ProcessInstanceIntent getState() {
        return (ProcessInstanceIntent)this.stateProp.getValue();
    }

    public IndexedRecord setState(ProcessInstanceIntent state) {
        this.stateProp.setValue((Enum)state);
        return this;
    }

    public boolean hasState(ProcessInstanceIntent state) {
        return this.getState() == state;
    }

    public ProcessInstanceRecord getValue() {
        return (ProcessInstanceRecord)this.valueProp.getValue();
    }

    public IndexedRecord setValue(ProcessInstanceRecord value) {
        UnsafeBuffer valueBuffer = new UnsafeBuffer(0L, 0);
        int encodedLength = value.getLength();
        valueBuffer.wrap(new byte[encodedLength]);
        value.write((MutableDirectBuffer)valueBuffer, 0);
        ((ProcessInstanceRecord)this.valueProp.getValue()).wrap((DirectBuffer)valueBuffer, 0, encodedLength);
        return this;
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        byte[] bytes = new byte[length];
        UnsafeBuffer mutableBuffer = new UnsafeBuffer(bytes);
        buffer.getBytes(offset, bytes, 0, length);
        super.wrap((DirectBuffer)mutableBuffer, 0, length);
    }
}

