/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.message;

import io.zeebe.db.ColumnFamily;
import io.zeebe.db.DbKey;
import io.zeebe.db.DbValue;
import io.zeebe.db.TransactionContext;
import io.zeebe.db.ZeebeDb;
import io.zeebe.db.impl.DbCompositeKey;
import io.zeebe.db.impl.DbLong;
import io.zeebe.db.impl.DbNil;
import io.zeebe.db.impl.DbString;
import io.zeebe.engine.state.ZbColumnFamilies;
import io.zeebe.engine.state.message.SubscriptionValue;
import io.zeebe.engine.state.mutable.MutableMessageStartEventSubscriptionState;
import io.zeebe.protocol.impl.record.value.message.MessageStartEventSubscriptionRecord;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;

public final class DbMessageStartEventSubscriptionState
implements MutableMessageStartEventSubscriptionState {
    private final DbString messageName;
    private final DbLong processDefinitionKey;
    private final DbCompositeKey<DbString, DbLong> messageNameAndProcessDefinitionKey;
    private final ColumnFamily<DbCompositeKey<DbString, DbLong>, SubscriptionValue> subscriptionsColumnFamily;
    private final SubscriptionValue subscriptionValue = new SubscriptionValue();
    private final DbCompositeKey<DbLong, DbString> processDefinitionKeyAndMessageName;
    private final ColumnFamily<DbCompositeKey<DbLong, DbString>, DbNil> subscriptionsOfProcessDefinitionKeyColumnFamily;

    public DbMessageStartEventSubscriptionState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.messageName = new DbString();
        this.processDefinitionKey = new DbLong();
        this.messageNameAndProcessDefinitionKey = new DbCompositeKey((DbKey)this.messageName, (DbKey)this.processDefinitionKey);
        this.subscriptionsColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_START_EVENT_SUBSCRIPTION_BY_NAME_AND_KEY, transactionContext, this.messageNameAndProcessDefinitionKey, (DbValue)this.subscriptionValue);
        this.processDefinitionKeyAndMessageName = new DbCompositeKey((DbKey)this.processDefinitionKey, (DbKey)this.messageName);
        this.subscriptionsOfProcessDefinitionKeyColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_START_EVENT_SUBSCRIPTION_BY_KEY_AND_NAME, transactionContext, this.processDefinitionKeyAndMessageName, (DbValue)DbNil.INSTANCE);
    }

    @Override
    public void put(MessageStartEventSubscriptionRecord subscription) {
        this.subscriptionValue.set(subscription);
        this.messageName.wrapBuffer(subscription.getMessageNameBuffer());
        this.processDefinitionKey.wrapLong(subscription.getProcessDefinitionKey());
        this.subscriptionsColumnFamily.put(this.messageNameAndProcessDefinitionKey, (DbValue)this.subscriptionValue);
        this.subscriptionsOfProcessDefinitionKeyColumnFamily.put(this.processDefinitionKeyAndMessageName, (DbValue)DbNil.INSTANCE);
    }

    @Override
    public void removeSubscriptionsOfProcess(long processDefinitionKey) {
        this.processDefinitionKey.wrapLong(processDefinitionKey);
        this.subscriptionsOfProcessDefinitionKeyColumnFamily.whileEqualPrefix((DbKey)this.processDefinitionKey, (key, value) -> {
            this.subscriptionsColumnFamily.delete(this.messageNameAndProcessDefinitionKey);
            this.subscriptionsOfProcessDefinitionKeyColumnFamily.delete((DbKey)key);
        });
    }

    @Override
    public boolean exists(MessageStartEventSubscriptionRecord subscription) {
        this.messageName.wrapBuffer(subscription.getMessageNameBuffer());
        this.processDefinitionKey.wrapLong(subscription.getProcessDefinitionKey());
        return this.subscriptionsColumnFamily.exists(this.messageNameAndProcessDefinitionKey);
    }

    @Override
    public void visitSubscriptionsByMessageName(DirectBuffer messageName, Consumer<MessageStartEventSubscriptionRecord> visitor) {
        this.messageName.wrapBuffer(messageName);
        this.subscriptionsColumnFamily.whileEqualPrefix((DbKey)this.messageName, (key, value) -> visitor.accept(value.get()));
    }
}

