/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.message;

import io.zeebe.db.ColumnFamily;
import io.zeebe.db.DbKey;
import io.zeebe.db.DbValue;
import io.zeebe.db.TransactionContext;
import io.zeebe.db.ZeebeDb;
import io.zeebe.db.impl.DbCompositeKey;
import io.zeebe.db.impl.DbLong;
import io.zeebe.db.impl.DbNil;
import io.zeebe.db.impl.DbString;
import io.zeebe.engine.state.ZbColumnFamilies;
import io.zeebe.engine.state.immutable.ProcessInstanceSubscriptionState;
import io.zeebe.engine.state.message.ProcessInstanceSubscription;
import io.zeebe.engine.state.mutable.MutableProcessInstanceSubscriptionState;
import org.agrona.DirectBuffer;

public final class DbProcessInstanceSubscriptionState
implements MutableProcessInstanceSubscriptionState {
    private final TransactionContext transactionContext;
    private final DbLong elementInstanceKey;
    private final DbString messageName;
    private final DbCompositeKey<DbLong, DbString> elementKeyAndMessageName;
    private final ProcessInstanceSubscription processInstanceSubscription;
    private final ColumnFamily<DbCompositeKey<DbLong, DbString>, ProcessInstanceSubscription> subscriptionColumnFamily;
    private final DbLong sentTime;
    private final DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>> sentTimeCompositeKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>>, DbNil> sentTimeColumnFamily;

    public DbProcessInstanceSubscriptionState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.transactionContext = transactionContext;
        this.elementInstanceKey = new DbLong();
        this.messageName = new DbString();
        this.elementKeyAndMessageName = new DbCompositeKey((DbKey)this.elementInstanceKey, (DbKey)this.messageName);
        this.processInstanceSubscription = new ProcessInstanceSubscription();
        this.subscriptionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.PROCESS_SUBSCRIPTION_BY_KEY, transactionContext, this.elementKeyAndMessageName, (DbValue)this.processInstanceSubscription);
        this.sentTime = new DbLong();
        this.sentTimeCompositeKey = new DbCompositeKey((DbKey)this.sentTime, this.elementKeyAndMessageName);
        this.sentTimeColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.PROCESS_SUBSCRIPTION_BY_SENT_TIME, transactionContext, this.sentTimeCompositeKey, (DbValue)DbNil.INSTANCE);
    }

    @Override
    public void put(ProcessInstanceSubscription subscription) {
        this.wrapSubscriptionKeys(subscription.getElementInstanceKey(), subscription.getMessageName());
        this.subscriptionColumnFamily.put(this.elementKeyAndMessageName, (DbValue)subscription);
        this.sentTime.wrapLong(subscription.getCommandSentTime());
        this.sentTimeColumnFamily.put(this.sentTimeCompositeKey, (DbValue)DbNil.INSTANCE);
    }

    @Override
    public ProcessInstanceSubscription getSubscription(long elementInstanceKey, DirectBuffer messageName) {
        this.wrapSubscriptionKeys(elementInstanceKey, messageName);
        return (ProcessInstanceSubscription)this.subscriptionColumnFamily.get(this.elementKeyAndMessageName);
    }

    @Override
    public void visitElementSubscriptions(long elementInstanceKey, ProcessInstanceSubscriptionState.ProcessInstanceSubscriptionVisitor visitor) {
        this.elementInstanceKey.wrapLong(elementInstanceKey);
        this.subscriptionColumnFamily.whileEqualPrefix((DbKey)this.elementInstanceKey, (compositeKey, subscription) -> visitor.visit((ProcessInstanceSubscription)((Object)subscription)));
    }

    @Override
    public void visitSubscriptionBefore(long deadline, ProcessInstanceSubscriptionState.ProcessInstanceSubscriptionVisitor visitor) {
        this.sentTimeColumnFamily.whileTrue((compositeKey, nil) -> {
            long sentTime = ((DbLong)compositeKey.getFirst()).getValue();
            if (sentTime < deadline) {
                ProcessInstanceSubscription processInstanceSubscription = (ProcessInstanceSubscription)this.subscriptionColumnFamily.get((DbKey)((DbCompositeKey)compositeKey.getSecond()));
                return visitor.visit(processInstanceSubscription);
            }
            return false;
        });
    }

    @Override
    public void updateToOpenedState(ProcessInstanceSubscription subscription, int subscriptionPartitionId) {
        subscription.setOpened();
        subscription.setSubscriptionPartitionId(subscriptionPartitionId);
        this.updateSentTime(subscription, 0L);
    }

    @Override
    public void updateToClosingState(ProcessInstanceSubscription subscription, long sentTime) {
        subscription.setClosing();
        this.updateSentTime(subscription, sentTime);
    }

    @Override
    public void updateSentTimeInTransaction(ProcessInstanceSubscription subscription, long sentTime) {
        this.transactionContext.runInTransaction(() -> this.updateSentTime(subscription, sentTime));
    }

    @Override
    public void updateSentTime(ProcessInstanceSubscription subscription, long sentTime) {
        this.wrapSubscriptionKeys(subscription.getElementInstanceKey(), subscription.getMessageName());
        if (subscription.getCommandSentTime() > 0L) {
            this.sentTime.wrapLong(subscription.getCommandSentTime());
            this.sentTimeColumnFamily.delete(this.sentTimeCompositeKey);
        }
        subscription.setCommandSentTime(sentTime);
        this.subscriptionColumnFamily.put(this.elementKeyAndMessageName, (DbValue)subscription);
        if (sentTime > 0L) {
            this.sentTime.wrapLong(sentTime);
            this.sentTimeColumnFamily.put(this.sentTimeCompositeKey, (DbValue)DbNil.INSTANCE);
        }
    }

    @Override
    public boolean existSubscriptionForElementInstance(long elementInstanceKey, DirectBuffer messageName) {
        this.wrapSubscriptionKeys(elementInstanceKey, messageName);
        return this.subscriptionColumnFamily.exists(this.elementKeyAndMessageName);
    }

    @Override
    public boolean remove(long elementInstanceKey, DirectBuffer messageName) {
        boolean found;
        ProcessInstanceSubscription subscription = this.getSubscription(elementInstanceKey, messageName);
        boolean bl = found = subscription != null;
        if (found) {
            this.remove(subscription);
        }
        return found;
    }

    @Override
    public void remove(ProcessInstanceSubscription subscription) {
        this.wrapSubscriptionKeys(subscription.getElementInstanceKey(), subscription.getMessageName());
        this.subscriptionColumnFamily.delete(this.elementKeyAndMessageName);
        this.sentTime.wrapLong(subscription.getCommandSentTime());
        this.sentTimeColumnFamily.delete(this.sentTimeCompositeKey);
    }

    private void wrapSubscriptionKeys(long elementInstanceKey, DirectBuffer messageName) {
        this.elementInstanceKey.wrapLong(elementInstanceKey);
        this.messageName.wrapBuffer(messageName);
    }
}

