/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.message;

import io.zeebe.db.DbValue;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.msgpack.property.BaseProperty;
import io.zeebe.msgpack.property.BooleanProperty;
import io.zeebe.msgpack.property.EnumProperty;
import io.zeebe.msgpack.property.IntegerProperty;
import io.zeebe.msgpack.property.LongProperty;
import io.zeebe.msgpack.property.StringProperty;
import org.agrona.DirectBuffer;

public final class ProcessInstanceSubscription
extends UnpackedObject
implements DbValue {
    private final StringProperty messageNameProp = new StringProperty("messageName", "");
    private final StringProperty correlationKeyProp = new StringProperty("correlationKey", "");
    private final StringProperty targetElementIdProp = new StringProperty("targetElementId", "");
    private final StringProperty bpmnProcessIdProp = new StringProperty("bpmnProcessId", "");
    private final LongProperty processInstanceKeyProp = new LongProperty("processInstanceKey", -1L);
    private final LongProperty elementInstanceKeyProp = new LongProperty("elementInstanceKey", -1L);
    private final IntegerProperty subscriptionPartitionIdProp = new IntegerProperty("subscriptionPartitionId", -1);
    private final LongProperty commandSentTimeProp = new LongProperty("commandSentTime", 0L);
    private final BooleanProperty closeOnCorrelateProp = new BooleanProperty("closeOnCorrelate", true);
    private final EnumProperty<State> stateProp = new EnumProperty("state", State.class, (Enum)State.STATE_OPENING);

    public ProcessInstanceSubscription() {
        this.declareProperty((BaseProperty)this.messageNameProp).declareProperty((BaseProperty)this.correlationKeyProp).declareProperty((BaseProperty)this.targetElementIdProp).declareProperty((BaseProperty)this.bpmnProcessIdProp).declareProperty((BaseProperty)this.processInstanceKeyProp).declareProperty((BaseProperty)this.elementInstanceKeyProp).declareProperty((BaseProperty)this.subscriptionPartitionIdProp).declareProperty((BaseProperty)this.commandSentTimeProp).declareProperty((BaseProperty)this.closeOnCorrelateProp).declareProperty(this.stateProp);
    }

    public ProcessInstanceSubscription(long processInstanceKey, long elementInstanceKey, DirectBuffer targetElementId, DirectBuffer bpmnProcessId, DirectBuffer messageName, DirectBuffer correlationKey, long commandSentTime, boolean closeOnCorrelate) {
        this();
        this.processInstanceKeyProp.setValue(processInstanceKey);
        this.elementInstanceKeyProp.setValue(elementInstanceKey);
        this.bpmnProcessIdProp.setValue(bpmnProcessId);
        this.targetElementIdProp.setValue(targetElementId);
        this.commandSentTimeProp.setValue(commandSentTime);
        this.messageNameProp.setValue(messageName);
        this.correlationKeyProp.setValue(correlationKey);
        this.closeOnCorrelateProp.setValue(closeOnCorrelate);
    }

    public DirectBuffer getMessageName() {
        return this.messageNameProp.getValue();
    }

    public void setMessageName(DirectBuffer messageName) {
        this.messageNameProp.setValue(messageName);
    }

    public DirectBuffer getCorrelationKey() {
        return this.correlationKeyProp.getValue();
    }

    public void setCorrelationKey(DirectBuffer correlationKey) {
        this.correlationKeyProp.setValue(correlationKey);
    }

    public DirectBuffer getTargetElementId() {
        return this.targetElementIdProp.getValue();
    }

    public void setTargetElementId(DirectBuffer targetElementId) {
        this.targetElementIdProp.setValue(targetElementId);
    }

    public long getProcessInstanceKey() {
        return this.processInstanceKeyProp.getValue();
    }

    public void setProcessInstanceKey(long processInstanceKey) {
        this.processInstanceKeyProp.setValue(processInstanceKey);
    }

    public long getElementInstanceKey() {
        return this.elementInstanceKeyProp.getValue();
    }

    public void setElementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKeyProp.setValue(elementInstanceKey);
    }

    public DirectBuffer getBpmnProcessId() {
        return this.bpmnProcessIdProp.getValue();
    }

    public void setBpmnProcessId(DirectBuffer bpmnProcessId) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId);
    }

    public long getCommandSentTime() {
        return this.commandSentTimeProp.getValue();
    }

    public void setCommandSentTime(long commandSentTime) {
        this.commandSentTimeProp.setValue(commandSentTime);
    }

    public int getSubscriptionPartitionId() {
        return this.subscriptionPartitionIdProp.getValue();
    }

    public void setSubscriptionPartitionId(int subscriptionPartitionId) {
        this.subscriptionPartitionIdProp.setValue(subscriptionPartitionId);
    }

    public boolean shouldCloseOnCorrelate() {
        return this.closeOnCorrelateProp.getValue();
    }

    public void setCloseOnCorrelate(boolean closeOnCorrelate) {
        this.closeOnCorrelateProp.setValue(closeOnCorrelate);
    }

    public boolean isOpening() {
        return this.stateProp.getValue() == State.STATE_OPENING;
    }

    public boolean isClosing() {
        return this.stateProp.getValue() == State.STATE_CLOSING;
    }

    public void setOpened() {
        this.stateProp.setValue((Enum)State.STATE_OPENED);
    }

    public void setClosing() {
        this.stateProp.setValue((Enum)State.STATE_CLOSING);
    }

    private static enum State {
        STATE_OPENING,
        STATE_OPENED,
        STATE_CLOSING;

    }
}

