/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.processing;

import io.zeebe.db.ColumnFamily;
import io.zeebe.db.DbKey;
import io.zeebe.db.DbValue;
import io.zeebe.db.TransactionContext;
import io.zeebe.db.ZeebeDb;
import io.zeebe.db.impl.DbLong;
import io.zeebe.db.impl.DbNil;
import io.zeebe.engine.Loggers;
import io.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.zeebe.engine.state.ZbColumnFamilies;
import io.zeebe.engine.state.mutable.MutableBlackListState;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.ProcessInstanceRelatedIntent;
import io.zeebe.protocol.record.value.ProcessInstanceRelated;
import java.util.function.Consumer;
import org.slf4j.Logger;

public final class DbBlackListState
implements MutableBlackListState {
    private static final Logger LOG = Loggers.STREAM_PROCESSING;
    private static final String BLACKLIST_INSTANCE_MESSAGE = "Blacklist process instance {}, due to previous errors.";
    private final ColumnFamily<DbLong, DbNil> blackListColumnFamily;
    private final DbLong processInstanceKey = new DbLong();

    public DbBlackListState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.blackListColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.BLACKLIST, transactionContext, (DbKey)this.processInstanceKey, (DbValue)DbNil.INSTANCE);
    }

    private void blacklist(long key) {
        if (key >= 0L) {
            LOG.warn(BLACKLIST_INSTANCE_MESSAGE, (Object)this.processInstanceKey);
            this.processInstanceKey.wrapLong(key);
            this.blackListColumnFamily.put((DbKey)this.processInstanceKey, (DbValue)DbNil.INSTANCE);
        }
    }

    private boolean isOnBlacklist(long key) {
        this.processInstanceKey.wrapLong(key);
        return this.blackListColumnFamily.exists((DbKey)this.processInstanceKey);
    }

    @Override
    public boolean isOnBlacklist(TypedRecord record) {
        long processInstanceKey;
        Object value = record.getValue();
        if (value instanceof ProcessInstanceRelated && (processInstanceKey = ((ProcessInstanceRelated)value).getProcessInstanceKey()) >= 0L) {
            return this.isOnBlacklist(processInstanceKey);
        }
        return false;
    }

    @Override
    public boolean tryToBlacklist(TypedRecord<?> typedRecord, Consumer<Long> onBlacklistingInstance) {
        Object value;
        Intent intent = typedRecord.getIntent();
        if (this.shouldBeBlacklisted(intent) && (value = typedRecord.getValue()) instanceof ProcessInstanceRelated) {
            long processInstanceKey = ((ProcessInstanceRelated)value).getProcessInstanceKey();
            this.blacklist(processInstanceKey);
            onBlacklistingInstance.accept(processInstanceKey);
        }
        return false;
    }

    private boolean shouldBeBlacklisted(Intent intent) {
        if (intent instanceof ProcessInstanceRelatedIntent) {
            ProcessInstanceRelatedIntent processInstanceRelatedIntent = (ProcessInstanceRelatedIntent)intent;
            return processInstanceRelatedIntent.shouldBlacklistInstanceOnError();
        }
        return false;
    }
}

