/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.variable;

import io.zeebe.db.ColumnFamily;
import io.zeebe.db.DbKey;
import io.zeebe.db.DbValue;
import io.zeebe.db.TransactionContext;
import io.zeebe.db.ZeebeDb;
import io.zeebe.db.impl.DbCompositeKey;
import io.zeebe.db.impl.DbLong;
import io.zeebe.db.impl.DbString;
import io.zeebe.engine.state.ZbColumnFamilies;
import io.zeebe.engine.state.instance.ParentScopeKey;
import io.zeebe.engine.state.instance.TemporaryVariables;
import io.zeebe.engine.state.mutable.MutableVariableState;
import io.zeebe.engine.state.variable.VariableInstance;
import io.zeebe.msgpack.spec.MsgPackWriter;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.MutableInteger;
import org.agrona.collections.ObjectHashSet;
import org.agrona.concurrent.UnsafeBuffer;

public class DbVariableState
implements MutableVariableState {
    private final MsgPackWriter writer = new MsgPackWriter();
    private final ExpandableArrayBuffer documentResultBuffer = new ExpandableArrayBuffer();
    private final DirectBuffer resultView = new UnsafeBuffer(0L, 0);
    private final ColumnFamily<DbLong, ParentScopeKey> childParentColumnFamily;
    private final DbLong childKey;
    private final ParentScopeKey parentKey = new ParentScopeKey();
    private final ColumnFamily<DbCompositeKey<DbLong, DbString>, VariableInstance> variablesColumnFamily;
    private final DbCompositeKey<DbLong, DbString> scopeKeyVariableNameKey;
    private final DbLong scopeKey;
    private final DbString variableName;
    private final ColumnFamily<DbLong, TemporaryVariables> temporaryVariableStoreColumnFamily;
    private final TemporaryVariables temporaryVariables = new TemporaryVariables();
    private final VariableInstance newVariable = new VariableInstance();
    private final DirectBuffer variableNameView = new UnsafeBuffer(0L, 0);
    private final ObjectHashSet<DirectBuffer> collectedVariables = new ObjectHashSet();
    private final ObjectHashSet<DirectBuffer> variablesToCollect = new ObjectHashSet();

    public DbVariableState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.childKey = new DbLong();
        this.childParentColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.ELEMENT_INSTANCE_CHILD_PARENT, transactionContext, (DbKey)this.childKey, (DbValue)this.parentKey);
        this.scopeKey = new DbLong();
        this.variableName = new DbString();
        this.scopeKeyVariableNameKey = new DbCompositeKey((DbKey)this.scopeKey, (DbKey)this.variableName);
        this.variablesColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.VARIABLES, transactionContext, this.scopeKeyVariableNameKey, (DbValue)new VariableInstance());
        this.temporaryVariableStoreColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.TEMPORARY_VARIABLE_STORE, transactionContext, (DbKey)this.scopeKey, (DbValue)this.temporaryVariables);
    }

    @Override
    public void setVariableLocal(long key, long scopeKey, long processDefinitionKey, DirectBuffer name, DirectBuffer value) {
        this.setVariableLocal(key, scopeKey, processDefinitionKey, name, 0, name.capacity(), value, 0, value.capacity());
    }

    @Override
    public void setVariableLocal(long key, long scopeKey, long processDefinitionKey, DirectBuffer name, int nameOffset, int nameLength, DirectBuffer value, int valueOffset, int valueLength) {
        this.newVariable.reset();
        this.newVariable.setValue(value, valueOffset, valueLength);
        this.newVariable.setKey(key);
        this.scopeKey.wrapLong(scopeKey);
        this.variableNameView.wrap(name, nameOffset, nameLength);
        this.variableName.wrapBuffer(this.variableNameView);
        this.variablesColumnFamily.put(this.scopeKeyVariableNameKey, (DbValue)this.newVariable);
    }

    @Override
    public void createScope(long childKey, long parentKey) {
        this.childKey.wrapLong(childKey);
        this.parentKey.set(parentKey);
        this.childParentColumnFamily.put((DbKey)this.childKey, (DbValue)this.parentKey);
    }

    @Override
    public void removeScope(long scopeKey) {
        this.scopeKey.wrapLong(scopeKey);
        this.removeAllVariables(scopeKey);
        this.childKey.wrapLong(scopeKey);
        this.childParentColumnFamily.delete((DbKey)this.childKey);
    }

    @Override
    public void removeAllVariables(long scopeKey) {
        this.visitVariablesLocal(scopeKey, dbString -> true, (dbString, variable1) -> this.variablesColumnFamily.delete(this.scopeKeyVariableNameKey), () -> false);
    }

    @Override
    public void setTemporaryVariables(long scopeKey, DirectBuffer variables) {
        this.scopeKey.wrapLong(scopeKey);
        this.temporaryVariables.set(variables);
        this.temporaryVariableStoreColumnFamily.put((DbKey)this.scopeKey, (DbValue)this.temporaryVariables);
    }

    @Override
    public void removeTemporaryVariables(long scopeKey) {
        this.scopeKey.wrapLong(scopeKey);
        this.temporaryVariableStoreColumnFamily.delete((DbKey)this.scopeKey);
    }

    @Override
    public DirectBuffer getVariableLocal(long scopeKey, DirectBuffer name) {
        VariableInstance variable = this.getVariableLocal(scopeKey, name, 0, name.capacity());
        if (variable != null) {
            return variable.getValue();
        }
        return null;
    }

    @Override
    public DirectBuffer getVariable(long scopeKey, DirectBuffer name) {
        return this.getVariable(scopeKey, name, 0, name.capacity());
    }

    @Override
    public DirectBuffer getVariable(long scopeKey, DirectBuffer name, int nameOffset, int nameLength) {
        long currentScopeKey = scopeKey;
        do {
            VariableInstance variable;
            if ((variable = this.getVariableLocal(currentScopeKey, name, nameOffset, nameLength)) == null) continue;
            return variable.getValue();
        } while ((currentScopeKey = this.getParentScopeKey(currentScopeKey)) >= 0L);
        return null;
    }

    @Override
    public DirectBuffer getVariablesAsDocument(long scopeKey) {
        this.collectedVariables.clear();
        this.writer.wrap((MutableDirectBuffer)this.documentResultBuffer, 0);
        this.writer.reserveMapHeader();
        this.visitVariables(scopeKey, name -> !this.collectedVariables.contains((Object)name.getBuffer()), (name, value) -> {
            DirectBuffer variableNameBuffer = name.getBuffer();
            this.writer.writeString(variableNameBuffer);
            this.writer.writeRaw(value.getValue());
            UnsafeBuffer nameView = new UnsafeBuffer(variableNameBuffer);
            this.collectedVariables.add((Object)nameView);
        }, () -> false);
        this.writer.writeReservedMapHeader(0, this.collectedVariables.size());
        this.resultView.wrap((DirectBuffer)this.documentResultBuffer, 0, this.writer.getOffset());
        return this.resultView;
    }

    @Override
    public DirectBuffer getVariablesAsDocument(long scopeKey, Collection<DirectBuffer> names) {
        this.variablesToCollect.clear();
        this.variablesToCollect.addAll(names);
        this.writer.wrap((MutableDirectBuffer)this.documentResultBuffer, 0);
        this.writer.reserveMapHeader();
        this.visitVariables(scopeKey, name -> this.variablesToCollect.contains((Object)name.getBuffer()), (name, value) -> {
            this.writer.writeString(name.getBuffer());
            this.writer.writeRaw(value.getValue());
            this.variablesToCollect.remove((Object)name.getBuffer());
        }, () -> this.variablesToCollect.isEmpty());
        this.writer.writeReservedMapHeader(0, names.size() - this.variablesToCollect.size());
        this.resultView.wrap((DirectBuffer)this.documentResultBuffer, 0, this.writer.getOffset());
        return this.resultView;
    }

    @Override
    public DirectBuffer getVariablesLocalAsDocument(long scopeKey) {
        this.writer.wrap((MutableDirectBuffer)this.documentResultBuffer, 0);
        this.writer.reserveMapHeader();
        MutableInteger variableCount = new MutableInteger();
        this.visitVariablesLocal(scopeKey, name -> true, (name, value) -> {
            this.writer.writeString(name.getBuffer());
            this.writer.writeRaw(value.getValue());
            variableCount.addAndGet(1);
        }, () -> false);
        this.writer.writeReservedMapHeader(0, variableCount.get());
        this.resultView.wrap((DirectBuffer)this.documentResultBuffer, 0, this.writer.getOffset());
        return this.resultView;
    }

    @Override
    public DirectBuffer getTemporaryVariables(long scopeKey) {
        this.scopeKey.wrapLong(scopeKey);
        TemporaryVariables variables = (TemporaryVariables)this.temporaryVariableStoreColumnFamily.get((DbKey)this.scopeKey);
        return variables == null || variables.get().byteArray() == null ? null : variables.get();
    }

    @Override
    public boolean isEmpty() {
        return this.variablesColumnFamily.isEmpty() && this.childParentColumnFamily.isEmpty() && this.temporaryVariableStoreColumnFamily.isEmpty();
    }

    @Override
    public VariableInstance getVariableInstanceLocal(long scopeKey, DirectBuffer name) {
        return this.getVariableLocal(scopeKey, name, 0, name.capacity());
    }

    @Override
    public long getParentScopeKey(long childScopeKey) {
        this.childKey.wrapLong(childScopeKey);
        ParentScopeKey parentScopeKey = (ParentScopeKey)this.childParentColumnFamily.get((DbKey)this.childKey);
        return parentScopeKey != null ? parentScopeKey.get() : -1L;
    }

    private VariableInstance getVariableLocal(long scopeKey, DirectBuffer name, int nameOffset, int nameLength) {
        this.scopeKey.wrapLong(scopeKey);
        this.variableNameView.wrap(name, nameOffset, nameLength);
        this.variableName.wrapBuffer(this.variableNameView);
        return (VariableInstance)this.variablesColumnFamily.get(this.scopeKeyVariableNameKey);
    }

    private void visitVariables(long scopeKey, Predicate<DbString> filter, BiConsumer<DbString, VariableInstance> variableConsumer, BooleanSupplier completionCondition) {
        boolean completed;
        long currentScope = scopeKey;
        do {
            completed = this.visitVariablesLocal(currentScope, filter, variableConsumer, completionCondition);
            currentScope = this.getParentScopeKey(currentScope);
        } while (!completed && currentScope >= 0L);
    }

    private boolean visitVariablesLocal(long scopeKey, Predicate<DbString> variableFilter, BiConsumer<DbString, VariableInstance> variableConsumer, BooleanSupplier completionCondition) {
        this.scopeKey.wrapLong(scopeKey);
        this.variablesColumnFamily.whileEqualPrefix((DbKey)this.scopeKey, (compositeKey, variable) -> {
            DbString name = (DbString)compositeKey.getSecond();
            if (variableFilter.test(name)) {
                variableConsumer.accept(name, (VariableInstance)variable);
            }
            return !completionCondition.getAsBoolean();
        });
        return false;
    }
}

