/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.journal.file;

import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;

class JournalMetrics {
    private static final String NAMESPACE = "atomix";
    private static final String PARTITION_LABEL = "partition";
    private static final Histogram SEGMENT_CREATION_TIME = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("atomix")).name("segment_creation_time")).help("Time spend to create a new segment")).labelNames(new String[]{"partition"})).register();
    private static final Histogram SEGMENT_TRUNCATE_TIME = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("atomix")).name("segment_truncate_time")).help("Time spend to truncate a segment")).labelNames(new String[]{"partition"})).register();
    private static final Histogram SEGMENT_FLUSH_TIME = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("atomix")).name("segment_flush_time")).help("Time spend to flush segment to disk")).labelNames(new String[]{"partition"})).register();
    private static final Gauge SEGMENT_COUNT = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("atomix")).name("segment_count")).help("Number of segments")).labelNames(new String[]{"partition"})).register();
    private static final Gauge JOURNAL_OPEN_DURATION = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("atomix")).name("journal_open_time")).help("Time taken to open the journal")).labelNames(new String[]{"partition"})).register();
    private final String logName;

    public JournalMetrics(String logName) {
        this.logName = logName;
    }

    public void observeSegmentCreation(Runnable segmentCreation) {
        ((Histogram.Child)SEGMENT_CREATION_TIME.labels(new String[]{this.logName})).time(segmentCreation);
    }

    public void observeSegmentFlush(Runnable segmentFlush) {
        ((Histogram.Child)SEGMENT_FLUSH_TIME.labels(new String[]{this.logName})).time(segmentFlush);
    }

    public void observeSegmentTruncation(Runnable segmentTruncation) {
        ((Histogram.Child)SEGMENT_TRUNCATE_TIME.labels(new String[]{this.logName})).time(segmentTruncation);
    }

    public void observeJournalOpenDuration(long durationMillis) {
        ((Gauge.Child)JOURNAL_OPEN_DURATION.labels(new String[]{this.logName})).set((double)((float)durationMillis / 1000.0f));
    }

    public void incSegmentCount() {
        ((Gauge.Child)SEGMENT_COUNT.labels(new String[]{this.logName})).inc();
    }

    public void decSegmentCount() {
        ((Gauge.Child)SEGMENT_COUNT.labels(new String[]{this.logName})).dec();
    }
}

