/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.journal.file;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.zeebe.journal.StorageException;
import io.zeebe.journal.file.JournalIndex;
import io.zeebe.journal.file.JournalSegmentDescriptor;
import io.zeebe.journal.file.JournalSegmentFile;
import io.zeebe.journal.file.MappedJournalSegmentReader;
import io.zeebe.journal.file.MappedJournalSegmentWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Set;

class JournalSegment
implements AutoCloseable {
    private final JournalSegmentFile file;
    private final JournalSegmentDescriptor descriptor;
    private final JournalIndex index;
    private final MappedJournalSegmentWriter writer;
    private final Set<MappedJournalSegmentReader> readers = Sets.newConcurrentHashSet();
    private boolean open = true;

    public JournalSegment(JournalSegmentFile file, JournalSegmentDescriptor descriptor, int maxEntrySize, JournalIndex journalIndex) {
        this.file = file;
        this.descriptor = descriptor;
        this.index = journalIndex;
        this.writer = this.createWriter(file, maxEntrySize);
    }

    public long id() {
        return this.descriptor.id();
    }

    public long version() {
        return this.descriptor.version();
    }

    public long index() {
        return this.descriptor.index();
    }

    public long lastIndex() {
        return this.writer.getLastIndex();
    }

    public JournalSegmentFile file() {
        return this.file;
    }

    public JournalSegmentDescriptor descriptor() {
        return this.descriptor;
    }

    public boolean isEmpty() {
        return this.length() == 0L;
    }

    public long length() {
        return this.writer.getNextIndex() - this.index();
    }

    public MappedJournalSegmentWriter writer() {
        this.checkOpen();
        return this.writer;
    }

    MappedJournalSegmentReader createReader() {
        this.checkOpen();
        return new MappedJournalSegmentReader(this.file, this, this.index);
    }

    private MappedJournalSegmentWriter createWriter(JournalSegmentFile file, int maxEntrySize) {
        return new MappedJournalSegmentWriter(file, this, maxEntrySize, this.index);
    }

    void onReaderClosed(MappedJournalSegmentReader reader) {
        this.readers.remove(reader);
    }

    private void checkOpen() {
        Preconditions.checkState((boolean)this.open, (Object)"Segment not open");
    }

    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() {
        this.writer.close();
        this.readers.forEach(MappedJournalSegmentReader::close);
        this.open = false;
    }

    public void delete() {
        try {
            Files.deleteIfExists(this.file.file().toPath());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id()).add("version", this.version()).add("index", this.index()).toString();
    }
}

