/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.journal.file;

import com.google.common.base.Preconditions;
import io.zeebe.journal.StorageException;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;

final class JournalSegmentFile {
    private static final char PART_SEPARATOR = '-';
    private static final char EXTENSION_SEPARATOR = '.';
    private static final String EXTENSION = "log";
    private final File file;

    JournalSegmentFile(File file) {
        this.file = file;
    }

    public static boolean isSegmentFile(String name, File file) {
        return JournalSegmentFile.isSegmentFile(name, file.getName());
    }

    public static boolean isSegmentFile(String journalName, String fileName) {
        Preconditions.checkNotNull((Object)journalName, (Object)"journalName cannot be null");
        Preconditions.checkNotNull((Object)fileName, (Object)"fileName cannot be null");
        int partSeparator = fileName.lastIndexOf(45);
        int extensionSeparator = fileName.lastIndexOf(46);
        if (extensionSeparator == -1 || partSeparator == -1 || extensionSeparator < partSeparator || !fileName.endsWith(EXTENSION)) {
            return false;
        }
        for (int i = partSeparator + 1; i < extensionSeparator; ++i) {
            if (Character.isDigit(fileName.charAt(i))) continue;
            return false;
        }
        return fileName.startsWith(journalName);
    }

    static File createSegmentFile(String name, File directory, long id) {
        return new File(directory, String.format("%s-%d.log", Preconditions.checkNotNull((Object)name, (Object)"name cannot be null"), id));
    }

    public File file() {
        return this.file;
    }

    FileChannel openChannel(StandardOpenOption ... options) {
        try {
            return FileChannel.open(this.file.toPath(), options);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    public String name() {
        return this.file.getName();
    }
}

