/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.journal.file;

import io.zeebe.journal.JournalRecord;
import io.zeebe.journal.file.IndexInfo;
import io.zeebe.journal.file.JournalIndex;
import io.zeebe.journal.file.JournalSegment;
import io.zeebe.journal.file.JournalSegmentFile;
import io.zeebe.journal.file.record.JournalRecordReaderUtil;
import io.zeebe.journal.file.record.SBESerializer;
import java.io.File;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.NoSuchElementException;
import org.agrona.IoUtil;

class MappedJournalSegmentReader {
    private final MappedByteBuffer buffer;
    private final JournalIndex index;
    private final JournalSegment segment;
    private JournalRecord currentEntry;
    private JournalRecord nextEntry;
    private final JournalRecordReaderUtil recordReader;

    MappedJournalSegmentReader(JournalSegmentFile file, JournalSegment segment, JournalIndex index) {
        this.index = index;
        this.segment = segment;
        this.recordReader = new JournalRecordReaderUtil(new SBESerializer());
        this.buffer = IoUtil.mapExistingFile((File)file.file(), (FileChannel.MapMode)FileChannel.MapMode.READ_ONLY, (String)file.name(), (long)0L, (long)segment.descriptor().maxSegmentSize());
        this.reset();
    }

    public JournalRecord getCurrentEntry() {
        return this.currentEntry;
    }

    public JournalRecord getNextEntry() {
        return this.nextEntry;
    }

    public boolean hasNext() {
        if (this.nextEntry == null) {
            this.readNext(this.getNextIndex());
        }
        return this.nextEntry != null;
    }

    public JournalRecord next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.currentEntry = this.nextEntry;
        this.nextEntry = null;
        this.readNext(this.getNextIndex());
        return this.currentEntry;
    }

    public void reset() {
        this.buffer.position(64);
        this.currentEntry = null;
        this.nextEntry = null;
        this.readNext(this.getNextIndex());
    }

    public boolean seek(long index) {
        long firstIndex = this.segment.index();
        long lastIndex = this.segment.lastIndex();
        this.reset();
        IndexInfo position = this.index.lookup(index - 1L);
        if (position != null && position.index() >= firstIndex && position.index() <= lastIndex) {
            this.currentEntry = null;
            this.buffer.position(position.position());
            this.nextEntry = null;
            this.readNext(position.index());
        }
        while (this.getNextIndex() < index && this.hasNext()) {
            this.next();
        }
        return this.nextEntry != null && this.nextEntry.index() == index;
    }

    public void close() {
        IoUtil.unmap((MappedByteBuffer)this.buffer);
        this.segment.onReaderClosed(this);
    }

    long getNextIndex() {
        return this.currentEntry == null ? this.segment.index() : this.currentEntry.index() + 1L;
    }

    private void readNext(long expectedIndex) {
        this.nextEntry = this.recordReader.read(this.buffer, expectedIndex);
    }

    long getCurrentIndex() {
        return this.currentEntry != null ? this.currentEntry.index() : 0L;
    }
}

