/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.journal.file;

import io.zeebe.journal.JournalRecord;
import io.zeebe.journal.StorageException;
import io.zeebe.journal.file.ChecksumGenerator;
import io.zeebe.journal.file.JournalIndex;
import io.zeebe.journal.file.JournalSegment;
import io.zeebe.journal.file.JournalSegmentFile;
import io.zeebe.journal.file.record.JournalRecordReaderUtil;
import io.zeebe.journal.file.record.JournalRecordSerializer;
import io.zeebe.journal.file.record.PersistedJournalRecord;
import io.zeebe.journal.file.record.RecordData;
import io.zeebe.journal.file.record.RecordMetadata;
import io.zeebe.journal.file.record.SBESerializer;
import java.io.File;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.agrona.DirectBuffer;
import org.agrona.IoUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

class MappedJournalSegmentWriter {
    private final MappedByteBuffer buffer;
    private final JournalSegment segment;
    private final JournalIndex index;
    private final long firstIndex;
    private JournalRecord lastEntry;
    private boolean isOpen = true;
    private final JournalRecordReaderUtil recordUtil;
    private final int maxEntrySize;
    private final ChecksumGenerator checksumGenerator = new ChecksumGenerator();
    private final JournalRecordSerializer serializer = new SBESerializer();
    private final MutableDirectBuffer writeBuffer = new UnsafeBuffer();

    MappedJournalSegmentWriter(JournalSegmentFile file, JournalSegment segment, int maxEntrySize, JournalIndex index) {
        this.segment = segment;
        this.maxEntrySize = maxEntrySize;
        this.recordUtil = new JournalRecordReaderUtil(this.serializer);
        this.index = index;
        this.firstIndex = segment.index();
        this.buffer = MappedJournalSegmentWriter.mapFile(file, segment);
        this.writeBuffer.wrap((ByteBuffer)this.buffer);
        this.reset(0L);
    }

    private static MappedByteBuffer mapFile(JournalSegmentFile file, JournalSegment segment) {
        return IoUtil.mapExistingFile((File)file.file(), (String)file.name(), (long)0L, (long)segment.descriptor().maxSegmentSize());
    }

    public long getLastIndex() {
        return this.lastEntry != null ? this.lastEntry.index() : this.segment.index() - 1L;
    }

    public JournalRecord getLastEntry() {
        return this.lastEntry;
    }

    public long getNextIndex() {
        if (this.lastEntry != null) {
            return this.lastEntry.index() + 1L;
        }
        return this.firstIndex;
    }

    public JournalRecord append(long asqn, DirectBuffer data) {
        int recordLength;
        long recordIndex = this.getNextIndex();
        int startPosition = this.buffer.position();
        int metadataLength = this.serializer.getMetadataLength();
        RecordData indexedRecord = new RecordData(recordIndex, asqn, data);
        this.checkCanWrite(indexedRecord);
        try {
            recordLength = this.writeRecord(startPosition + metadataLength, indexedRecord);
        }
        catch (BufferOverflowException boe) {
            this.buffer.position(startPosition);
            throw boe;
        }
        long checksum = this.checksumGenerator.compute(this.buffer, startPosition + metadataLength, recordLength);
        this.writeMetadata(startPosition, recordLength, checksum);
        this.updateLastWrittenEntry(startPosition, metadataLength, recordLength);
        this.buffer.position(startPosition + metadataLength + recordLength);
        return this.lastEntry;
    }

    public void append(JournalRecord record) {
        int recordLength;
        long nextIndex = this.getNextIndex();
        if (record.index() != nextIndex) {
            throw new StorageException.InvalidIndex(String.format("The record index is not sequential. Expected the next index to be %d, but the record to append has index %d", nextIndex, record.index()));
        }
        int startPosition = this.buffer.position();
        int metadataLength = this.serializer.getMetadataLength();
        RecordData indexedRecord = new RecordData(record.index(), record.asqn(), record.data());
        this.checkCanWrite(indexedRecord);
        try {
            recordLength = this.writeRecord(startPosition + metadataLength, indexedRecord);
        }
        catch (BufferOverflowException boe) {
            this.buffer.position(startPosition);
            throw boe;
        }
        long checksum = this.checksumGenerator.compute(this.buffer, startPosition + metadataLength, recordLength);
        if (record.checksum() != checksum) {
            this.buffer.position(startPosition);
            throw new StorageException.InvalidChecksum(String.format("Failed to append record %s. Checksum does not match", record));
        }
        this.writeMetadata(startPosition, recordLength, checksum);
        this.updateLastWrittenEntry(startPosition, metadataLength, recordLength);
        this.buffer.position(startPosition + metadataLength + recordLength);
    }

    private void updateLastWrittenEntry(int startPosition, int metadataLength, int recordLength) {
        RecordMetadata metadata = this.serializer.readMetadata((DirectBuffer)this.writeBuffer, startPosition);
        RecordData data = this.serializer.readData((DirectBuffer)this.writeBuffer, startPosition + metadataLength, recordLength);
        this.lastEntry = new PersistedJournalRecord(metadata, data);
        this.index.index(this.lastEntry, startPosition);
    }

    private RecordMetadata writeMetadata(int startPosition, int recordLength, long checksum) {
        RecordMetadata recordMetadata = new RecordMetadata(checksum, recordLength);
        this.serializer.writeMetadata(recordMetadata, this.writeBuffer, startPosition);
        return recordMetadata;
    }

    private int writeRecord(int offset, RecordData indexedRecord) {
        int recordLength = this.serializer.writeData(indexedRecord, this.writeBuffer, offset);
        int nextEntryOffset = offset + recordLength;
        this.invalidateNextEntry(nextEntryOffset);
        return recordLength;
    }

    private void checkCanWrite(RecordData indexedRecord) {
        int recordOffset = this.serializer.getMetadataLength();
        int estimatedRecordLength = indexedRecord.data().capacity();
        if (estimatedRecordLength > this.maxEntrySize) {
            throw new StorageException.TooLarge("Entry size " + estimatedRecordLength + " exceeds maximum allowed bytes (" + this.maxEntrySize + ")");
        }
        if (this.buffer.position() + recordOffset + estimatedRecordLength > this.buffer.limit()) {
            throw new BufferOverflowException();
        }
    }

    private void invalidateNextEntry(int position) {
        if (position + 8 >= this.writeBuffer.capacity()) {
            return;
        }
        this.writeBuffer.putInt(position, 0);
        this.writeBuffer.putInt(position + 4, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset(long index) {
        this.buffer.position(64);
        this.buffer.mark();
        try {
            for (long nextIndex = this.firstIndex; index == 0L || nextIndex <= index; ++nextIndex) {
                JournalRecord nextEntry = this.recordUtil.read(this.buffer, nextIndex);
                if (nextEntry == null) {
                    break;
                }
                this.lastEntry = nextEntry;
                this.buffer.mark();
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
        }
        finally {
            this.buffer.reset();
        }
    }

    public void truncate(long index) {
        if (index >= this.getLastIndex()) {
            return;
        }
        this.lastEntry = null;
        this.index.deleteAfter(index);
        if (index < this.segment.index()) {
            this.buffer.position(64);
            this.invalidateNextEntry(64);
        } else {
            this.reset(index);
            this.invalidateNextEntry(this.buffer.position());
        }
    }

    public void flush() {
        this.buffer.force();
    }

    public void close() {
        if (this.isOpen) {
            this.isOpen = false;
            this.flush();
            IoUtil.unmap((MappedByteBuffer)this.buffer);
        }
    }

    public boolean isEmpty() {
        return this.lastEntry == null;
    }
}

