/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.journal.file;

import io.zeebe.journal.file.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class RecordMetadataDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 12;
    public static final int TEMPLATE_ID = 1;
    public static final int SCHEMA_ID = 7;
    public static final int SCHEMA_VERSION = 1;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final RecordMetadataDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 12;
    }

    public int sbeTemplateId() {
        return 1;
    }

    public int sbeSchemaId() {
        return 7;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public RecordMetadataDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int checksumId() {
        return 1;
    }

    public static int checksumSinceVersion() {
        return 0;
    }

    public static int checksumEncodingOffset() {
        return 0;
    }

    public static int checksumEncodingLength() {
        return 8;
    }

    public static String checksumMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long checksumNullValue() {
        return Long.MIN_VALUE;
    }

    public static long checksumMinValue() {
        return -9223372036854775807L;
    }

    public static long checksumMaxValue() {
        return Long.MAX_VALUE;
    }

    public long checksum() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int lengthId() {
        return 2;
    }

    public static int lengthSinceVersion() {
        return 0;
    }

    public static int lengthEncodingOffset() {
        return 8;
    }

    public static int lengthEncodingLength() {
        return 4;
    }

    public static String lengthMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int lengthNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int lengthMinValue() {
        return -2147483647;
    }

    public static int lengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int length() {
        return this.buffer.getInt(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        RecordMetadataDecoder decoder = new RecordMetadataDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[RecordMetadata](sbeTemplateId=");
        builder.append(1);
        builder.append("|sbeSchemaId=");
        builder.append(7);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 1) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(1);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 12) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(12);
        builder.append("):");
        builder.append("checksum=");
        builder.append(this.checksum());
        builder.append('|');
        builder.append("length=");
        builder.append(this.length());
        this.limit(originalLimit);
        return builder;
    }
}

